/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.handler;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.registries.ForgeRegistries;
import owmii.lib.config.Config;
import owmii.lib.util.Server;
import owmii.losttrinkets.LostTrinkets;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.player.PlayerData;
import owmii.losttrinkets.api.trinket.ITrinket;
import owmii.losttrinkets.api.trinket.Trinkets;
import owmii.losttrinkets.config.Configs;
import owmii.losttrinkets.network.packet.TrinketUnlockedPacket;

public class UnlockManager {
    private static final Set<ITrinket> ALL_TRINKETS = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof ITrinket).map(item -> (ITrinket)item).collect(Collectors.toCollection(LinkedHashSet::new));
    private static final Set<ITrinket> TRINKETS = Sets.newLinkedHashSet(ALL_TRINKETS);
    private static final Set<ITrinket> RANDOM_TRINKETS = Sets.newLinkedHashSet(ALL_TRINKETS);
    private static final List<WeightedTrinket> WEIGHTED_TRINKETS = new ArrayList<WeightedTrinket>();

    @Nullable
    public static ITrinket unlock(PlayerEntity player, boolean checkDelay) {
        if (player instanceof ServerPlayerEntity) {
            PlayerData data = LostTrinketsAPI.getData(player);
            if (!checkDelay || data.unlockDelay <= 0L) {
                Trinkets trinkets = LostTrinketsAPI.getTrinkets(player);
                WEIGHTED_TRINKETS.clear();
                WEIGHTED_TRINKETS.addAll(RANDOM_TRINKETS.stream().filter(trinket -> !trinkets.has((ITrinket)trinket)).map(WeightedTrinket::new).collect(Collectors.toList()));
                if (!WEIGHTED_TRINKETS.isEmpty()) {
                    WeightedTrinket item = (WeightedTrinket)WeightedRandom.func_76271_a((Random)player.field_70170_p.field_73012_v, WEIGHTED_TRINKETS);
                    UnlockManager.unlock(player, item.trinket, checkDelay);
                }
            }
        }
        return null;
    }

    public static boolean unlock(PlayerEntity player, ITrinket trinket, boolean checkDelay) {
        return UnlockManager.unlock(player, trinket, checkDelay, true);
    }

    public static boolean unlock(PlayerEntity player, ITrinket trinket, boolean checkDelay, boolean doNotification) {
        PlayerData data = LostTrinketsAPI.getData(player);
        if (!checkDelay || data.unlockDelay <= 0L) {
            Trinkets trinkets = LostTrinketsAPI.getTrinkets(player);
            if (LostTrinketsAPI.get().isEnabled(trinket) && trinkets.give(trinket)) {
                if (checkDelay) {
                    data.unlockDelay = (Long)Configs.GENERAL.unlockCooldown.get();
                }
                if (doNotification) {
                    LostTrinkets.NET.toClient((Object)new TrinketUnlockedPacket(Objects.requireNonNull(trinket.getItem().getRegistryName()).toString()), player);
                    ItemStack stack = new ItemStack((IItemProvider)trinket);
                    IFormattableTextComponent trinketName = stack.func_200301_q().func_230532_e_().func_240700_a_(style -> style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230551_b_, (Object)new HoverEvent.ItemHover(stack))));
                    Server.get().func_184103_al().func_232641_a_((ITextComponent)new TranslationTextComponent("chat.losttrinkets.unlocked.trinket", new Object[]{player.func_145748_c_(), trinketName}).func_240699_a_(TextFormatting.DARK_AQUA), ChatType.SYSTEM, Util.field_240973_b_);
                }
                return true;
            }
        }
        return false;
    }

    public static void refresh() {
        Set banned = ((List)Configs.GENERAL.blackList.get()).stream().map(ResourceLocation::new).collect(Collectors.toCollection(Sets::newLinkedHashSet));
        Set nonRandom = ((List)Configs.GENERAL.nonRandom.get()).stream().map(ResourceLocation::new).collect(Collectors.toCollection(Sets::newLinkedHashSet));
        LinkedHashSet seen = Sets.newLinkedHashSet();
        LostTrinkets.LOGGER.info(Config.MARKER, "Gathering Trinkets...");
        ALL_TRINKETS.forEach(trinket -> {
            ResourceLocation rl = trinket.func_199767_j().getRegistryName();
            seen.add(rl);
            if (banned.contains(rl)) {
                TRINKETS.remove(trinket);
                RANDOM_TRINKETS.remove(trinket);
                LostTrinkets.LOGGER.info(Config.MARKER, "Banned: " + rl);
            } else {
                TRINKETS.add((ITrinket)trinket);
                if (trinket.isUnlockable() && !nonRandom.contains(rl)) {
                    RANDOM_TRINKETS.add((ITrinket)trinket);
                    LostTrinkets.LOGGER.debug(Config.MARKER, "Enabled: " + rl);
                } else {
                    RANDOM_TRINKETS.remove(trinket);
                    LostTrinkets.LOGGER.info(Config.MARKER, "Non-Random: " + rl);
                }
            }
        });
        LostTrinkets.LOGGER.info(Config.MARKER, "All: " + ALL_TRINKETS.size());
        LostTrinkets.LOGGER.info(Config.MARKER, "Enabled: " + TRINKETS.size() + " Disabled: " + (ALL_TRINKETS.size() - TRINKETS.size()));
        LostTrinkets.LOGGER.info(Config.MARKER, "Random: " + RANDOM_TRINKETS.size() + " Non-Random: " + (TRINKETS.size() - RANDOM_TRINKETS.size()));
        banned.stream().filter(rl -> !seen.contains(rl)).forEach(rl -> LostTrinkets.LOGGER.warn(Config.MARKER, "Unknown Banned Trinket: " + rl));
        nonRandom.stream().filter(rl -> !seen.contains(rl)).forEach(rl -> LostTrinkets.LOGGER.warn(Config.MARKER, "Unknown Non-Random Trinket: " + rl));
        nonRandom.stream().filter(banned::contains).forEach(rl -> LostTrinkets.LOGGER.warn(Config.MARKER, "Redundant Non-Random Trinket (already banned): " + rl));
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.func_222817_e(() -> Server.get().func_184103_al().func_181057_v().forEach(player -> LostTrinketsAPI.getTrinkets((PlayerEntity)player).removeDisabled((PlayerEntity)player)));
        }
    }

    public static Set<ITrinket> getTrinkets() {
        return Collections.unmodifiableSet(TRINKETS);
    }

    public static Set<ITrinket> getRandomTrinkets() {
        return Collections.unmodifiableSet(RANDOM_TRINKETS);
    }

    static class WeightedTrinket
    extends WeightedRandom.Item {
        private final ITrinket trinket;

        public WeightedTrinket(ITrinket trinket) {
            super(trinket.getRarity().getWeight());
            this.trinket = trinket;
        }

        public ITrinket getTrinket() {
            return this.trinket;
        }
    }
}

