/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.items;

import com.flanks255.psu.gui.PSUContainer;
import com.flanks255.psu.inventory.PSUData;
import com.flanks255.psu.inventory.PSUItemHandler;
import com.flanks255.psu.inventory.StorageManager;
import com.flanks255.psu.items.PSUTier;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PocketStorageUnit
extends Item {
    private final PSUTier tier;
    private long lastInteractMills = 0L;
    private BlockPos lastInteractPos = new BlockPos(0, 0, 0);

    public PocketStorageUnit(PSUTier tierIn) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i));
        this.tier = tierIn;
    }

    public Rarity func_77613_e(ItemStack pStack) {
        return this.tier.rarity;
    }

    private boolean hasTranslation(String key) {
        return !I18n.func_135052_a((String)key, (Object[])new Object[0]).equals(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String translationKey = this.func_77658_a();
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(translationKey + ".info", new Object[]{new StringTextComponent(String.valueOf(this.tier.slots)).func_240699_a_(TextFormatting.GOLD), new StringTextComponent(String.valueOf(this.tier.capacity)).func_240699_a_(TextFormatting.GOLD)}).func_240699_a_(TextFormatting.GRAY));
            if (this.hasTranslation(translationKey + ".info2")) {
                tooltip.add((ITextComponent)new TranslationTextComponent(translationKey + ".info2").func_240699_a_(TextFormatting.GRAY));
            }
            if (this.hasTranslation(translationKey + ".info3")) {
                tooltip.add((ITextComponent)new TranslationTextComponent(translationKey + ".info3").func_240699_a_(TextFormatting.GRAY));
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("pocketstorage.util.deposit", new Object[]{new TranslationTextComponent("pocketstorage.util.sneak_right").func_240699_a_(TextFormatting.GOLD)}).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("pocketstorage.util.withdraw", new Object[]{new TranslationTextComponent("pocketstorage.util.sneak_left").func_240699_a_(TextFormatting.GOLD)}).func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("pocketstorage.util.shift", new Object[]{new TranslationTextComponent("pocketstorage.util.key_shift").func_240701_a_(new TextFormatting[]{TextFormatting.GOLD, TextFormatting.ITALIC})}).func_240699_a_(TextFormatting.GRAY));
        }
        if (flagIn.func_194127_a() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("UUID")) {
            UUID uuid = stack.func_77978_p().func_186857_a("UUID");
            tooltip.add((ITextComponent)new StringTextComponent("ID: " + uuid.toString().substring(0, 8)).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new PSUCaps(stack);
    }

    public boolean pickupEvent(EntityItemPickupEvent event, ItemStack stack) {
        Optional<PSUItemHandler> handlerOpt = StorageManager.get().getHandler(stack);
        return handlerOpt.map(handler -> {
            ItemStack pickedUp = event.getItem().func_92059_d();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack slot = handler.getStackInSlot(i);
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)slot, (ItemStack)pickedUp)) continue;
                handler.insertItem(i, pickedUp, false);
                pickedUp.func_190920_e(0);
                return true;
            }
            return false;
        }).orElse(false);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        this.openGUI(worldIn, playerIn, handIn);
        return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K) {
            World world = context.func_195991_k();
            BlockState bs = world.func_180495_p(context.func_195995_a());
            if (bs.hasTileEntity()) {
                TileEntity te = world.func_175625_s(context.func_195995_a());
                LazyOptional chestOptional = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
                Optional<PSUItemHandler> handler = StorageManager.get().getHandler(context.func_195996_i());
                handler.ifPresent(my -> chestOptional.ifPresent(chest -> {
                    boolean movedItems = false;
                    for (int i = 0; i < my.getSlots(); ++i) {
                        ItemStack stack = my.getStackInSlot(i);
                        if (stack.func_190926_b()) continue;
                        ItemStack backup = my.getStackInSlot(i);
                        backup.func_190920_e(1);
                        stack.func_190920_e(stack.func_190916_E() - 1);
                        ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)chest, (ItemStack)stack, (boolean)false);
                        movedItems = true;
                        if (remainder.func_190926_b()) {
                            my.getSlot(i).setCount(1);
                            continue;
                        }
                        my.getSlot(i).setCount(remainder.func_190916_E() + 1);
                    }
                    if (movedItems) {
                        context.func_195991_k().func_184133_a(null, context.func_195995_a(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, 0.5f + field_77697_d.nextFloat() * 0.5f);
                        context.func_195999_j().func_226292_a_(context.func_221531_n(), true);
                    }
                }));
            } else {
                this.openGUI(context.func_195991_k(), context.func_195999_j(), context.func_221531_n());
            }
        }
        return ActionResultType.FAIL;
    }

    public void onLeftClickEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (this.lastInteractPos.compareTo((Vector3i)event.getPos()) != 0) {
            this.onLeftClick(event);
        } else if (System.currentTimeMillis() - this.lastInteractMills > 1000L) {
            this.onLeftClick(event);
        }
        this.lastInteractMills = System.currentTimeMillis();
        this.lastInteractPos = event.getPos();
    }

    private void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        World world;
        BlockState bs;
        if (!event.getWorld().field_72995_K && (bs = (world = event.getWorld()).func_180495_p(event.getPos())).hasTileEntity()) {
            TileEntity te = world.func_175625_s(event.getPos());
            LazyOptional chestOptional = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
            Optional<PSUItemHandler> handler = StorageManager.get().getHandler(event.getPlayer().func_184614_ca());
            handler.ifPresent(my -> chestOptional.ifPresent(chest -> {
                boolean movedItems = false;
                for (int i = 0; i < chest.getSlots(); ++i) {
                    ItemStack stack = chest.getStackInSlot(i);
                    if (stack.func_190926_b() || !my.hasItem(stack)) continue;
                    ItemStack newStack = chest.extractItem(i, stack.func_190916_E(), false);
                    my.insertItemSlotless(newStack, false, false);
                    movedItems = true;
                }
                if (movedItems) {
                    event.getWorld().func_184133_a(null, event.getPos(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, 0.5f + field_77697_d.nextFloat() * 0.5f);
                }
            }));
        }
    }

    public static PSUData getData(ItemStack stack) {
        UUID uuid;
        if (!(stack.func_77973_b() instanceof PocketStorageUnit)) {
            return null;
        }
        CompoundNBT tag = stack.func_196082_o();
        if (!tag.func_74764_b("UUID")) {
            uuid = UUID.randomUUID();
            tag.func_186854_a("UUID", uuid);
        } else {
            uuid = tag.func_186857_a("UUID");
        }
        return StorageManager.get().getOrCreateStorage(uuid, ((PocketStorageUnit)stack.func_77973_b()).tier);
    }

    private void openGUI(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && playerIn instanceof ServerPlayerEntity && stack.func_77973_b() instanceof PocketStorageUnit) {
            PSUData data = PocketStorageUnit.getData(stack);
            PSUTier tier = ((PocketStorageUnit)stack.func_77973_b()).tier;
            UUID uuid = data.getUuid();
            if (stack.func_196082_o().func_74764_b("Slots")) {
                data.getHandler().deserializeNBT(stack.func_77978_p());
                stack.func_77978_p().func_82580_o("Slots");
                StorageManager.get().func_76185_a();
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("pocketstorage.util.migration"), Util.field_240973_b_);
            }
            data.updateAccessRecords(playerIn.func_200200_C_().getString(), System.currentTimeMillis());
            if (data.getTier().ordinal() < tier.ordinal()) {
                data.upgrade(tier);
                playerIn.func_145747_a((ITextComponent)new TranslationTextComponent("pocketstorage.util.upgrade"), Util.field_240973_b_);
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, playerEntity) -> new PSUContainer(windowId, playerInventory, uuid, data.getHandler()), stack.func_200301_q()), packetBuffer -> packetBuffer.func_150786_a(data.getHandler().serializeNBT()).func_179252_a(uuid).writeInt(data.getTier().ordinal()));
        }
    }

    static class PSUCaps
    implements ICapabilityProvider {
        private final ItemStack stack;
        private LazyOptional<IItemHandler> lazyOptional = LazyOptional.empty();

        public PSUCaps(ItemStack stack) {
            this.stack = stack;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                if (!this.lazyOptional.isPresent()) {
                    this.lazyOptional = StorageManager.get().getCapability(this.stack);
                }
                return this.lazyOptional.cast();
            }
            return LazyOptional.empty();
        }
    }
}

