/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.inventory;

import com.flanks255.psu.inventory.PSUData;
import com.flanks255.psu.inventory.PSUItemHandler;
import com.flanks255.psu.items.PSUTier;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.IItemHandler;

public class StorageManager
extends WorldSavedData {
    private static final String NAME = "pocketstorage_data";
    private static final HashMap<UUID, PSUData> data = new HashMap();
    public static final StorageManager blankClient = new StorageManager();

    public StorageManager() {
        super(NAME);
    }

    public static StorageManager get() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return (StorageManager)ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_).func_217481_x().func_215752_a(StorageManager::new, NAME);
        }
        return blankClient;
    }

    public HashMap<UUID, PSUData> getMap() {
        return data;
    }

    public Optional<PSUData> getStorage(UUID uuid) {
        if (data.containsKey(uuid)) {
            return Optional.of(data.get(uuid));
        }
        return Optional.empty();
    }

    public PSUData getOrCreateStorage(UUID uuid, PSUTier tier) {
        return data.computeIfAbsent(uuid, id -> {
            this.func_76185_a();
            return new PSUData((UUID)id, tier);
        });
    }

    public LazyOptional<IItemHandler> getCapability(UUID uuid) {
        if (data.containsKey(uuid)) {
            return data.get(uuid).getOptional();
        }
        return LazyOptional.empty();
    }

    public Optional<PSUItemHandler> getHandler(ItemStack stack) {
        UUID uuid;
        if (stack.func_196082_o().func_74764_b("UUID") && data.containsKey(uuid = stack.func_77978_p().func_186857_a("UUID"))) {
            return Optional.of(data.get(uuid).getHandler());
        }
        return Optional.empty();
    }

    public LazyOptional<IItemHandler> getCapability(ItemStack stack) {
        UUID uuid;
        if (stack.func_196082_o().func_74764_b("UUID") && data.containsKey(uuid = stack.func_77978_p().func_186857_a("UUID"))) {
            return data.get(uuid).getOptional();
        }
        return LazyOptional.empty();
    }

    public void func_76184_a(CompoundNBT nbt) {
        if (nbt.func_74764_b("PSUS")) {
            ListNBT list = nbt.func_150295_c("PSUS", 10);
            list.forEach(psuNBT -> PSUData.fromNBT((CompoundNBT)psuNBT).ifPresent(psu -> data.put(psu.getUuid(), (PSUData)psu)));
        }
    }

    @Nonnull
    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT backpacks = new ListNBT();
        data.forEach((uuid, backpackData) -> backpacks.add((Object)backpackData.toNBT()));
        compound.func_218657_a("PSUS", (INBT)backpacks);
        return compound;
    }
}

