/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class PSUSlot {
    public static final PSUSlot EMPTY = new PSUSlot();
    public ResourceLocation registryName;
    private int count;

    public PSUSlot() {
        this.count = 0;
        this.registryName = new ResourceLocation("minecraft:air");
    }

    public PSUSlot(ResourceLocation itemIn, int countIn) {
        this.count = countIn;
        this.registryName = itemIn;
    }

    public PSUSlot(ItemStack stack) {
        this.registryName = stack.func_77973_b().getRegistryName();
        this.count = stack.func_190916_E();
    }

    public PSUSlot(CompoundNBT tag) {
        this.readNBT(tag);
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public void decrementCount(int dec) {
        this.count -= dec;
    }

    public void incrementCount(int inc, int cap) {
        this.count = Math.min(this.count + inc, cap);
    }

    public int incrementCount(int inc) {
        this.count += inc;
        return this.count;
    }

    public boolean isEmpty() {
        return this.count <= 0;
    }

    public ItemStack getStack() {
        return new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(this.registryName));
    }

    public CompoundNBT writeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("Item", this.registryName.toString());
        tag.func_74768_a("Count", this.count);
        return tag;
    }

    public void readNBT(CompoundNBT tag) {
        if (!tag.func_74764_b("Item")) {
            return;
        }
        this.registryName = new ResourceLocation(tag.func_74779_i("Item"));
        this.count = tag.func_74764_b("Count") ? tag.func_74762_e("Count") : 0;
    }
}

