/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.inventory;

import com.flanks255.psu.inventory.PSUSlot;
import com.flanks255.psu.inventory.StorageManager;
import com.flanks255.psu.items.PSUTier;
import com.flanks255.psu.items.PocketStorageUnit;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class PSUItemHandler
implements IItemHandler,
INBTSerializable<CompoundNBT> {
    private NonNullList<PSUSlot> slots;
    private int slotCount;
    private int slotCapacity;

    public PSUItemHandler(PSUTier tier) {
        this.slotCount = tier.slots;
        this.slotCapacity = tier.capacity;
        this.slots = NonNullList.func_191197_a((int)tier.slots, (Object)PSUSlot.EMPTY);
    }

    void checkIndex(int slot) {
        if (slot < 0 || slot >= this.slots.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.slots.size() + ")");
        }
    }

    public int getSlots() {
        return this.slotCount;
    }

    public int getSlotLimit(int slot) {
        return this.slotCapacity;
    }

    public PSUSlot getSlot(int slot) {
        this.checkIndex(slot);
        return (PSUSlot)this.slots.get(slot);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.checkIndex(slot);
        if (!((PSUSlot)this.slots.get(slot)).isEmpty() && ((PSUSlot)this.slots.get(slot)).getCount() > 0) {
            ItemStack tmp = ((PSUSlot)this.slots.get(slot)).getStack();
            tmp.func_190920_e(((PSUSlot)this.slots.get(slot)).getCount());
            return tmp;
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasItem(ItemStack stack) {
        for (PSUSlot slot : this.slots) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)slot.getStack(), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public void upgrade(PSUTier tier) {
        if (tier.slots <= this.slots.size()) {
            return;
        }
        NonNullList<PSUSlot> oldStacks = this.slots;
        this.slots = NonNullList.func_191197_a((int)tier.slots, (Object)PSUSlot.EMPTY);
        for (int i = 0; i < oldStacks.size(); ++i) {
            this.slots.set(i, oldStacks.get(i));
        }
        this.slotCount = tier.slots;
        this.slotCapacity = tier.capacity;
    }

    public ItemStack insertItemSlotless(@Nonnull ItemStack stack, boolean allowEmpty, boolean allowVoid) {
        if (stack.func_190926_b() || stack.func_77942_o()) {
            return ItemStack.field_190927_a;
        }
        for (PSUSlot slot : this.slots) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)slot.getStack(), (ItemStack)stack)) continue;
            int remainder = allowVoid ? 0 : Math.max(slot.getCount() + stack.func_190916_E() - this.slotCapacity, 0);
            slot.setCount(Math.min(slot.getCount() + stack.func_190916_E(), this.slotCapacity));
            this.onContentsChanged();
            ItemStack tmpstack = stack.func_77946_l();
            stack.func_190920_e(remainder);
            return tmpstack;
        }
        if (allowEmpty) {
            for (int n = 0; n < this.slots.size(); ++n) {
                if (!((PSUSlot)this.slots.get(n)).isEmpty()) continue;
                this.slots.set(n, (Object)new PSUSlot(stack));
                this.onContentsChanged();
                ItemStack tmpstack = stack.func_77946_l();
                stack.func_190920_e(0);
                return tmpstack;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.checkIndex(slot);
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        if (((PSUSlot)this.slots.get(slot)).isEmpty()) {
            if (!simulate) {
                this.slots.set(slot, (Object)new PSUSlot(stack));
                this.onContentsChanged();
            }
            return ItemStack.field_190927_a;
        }
        if (((PSUSlot)this.slots.get((int)slot)).registryName.equals((Object)stack.func_77973_b().getRegistryName())) {
            if (!simulate) {
                PSUSlot tmp = (PSUSlot)this.slots.get(slot);
                tmp.incrementCount(stack.func_190916_E(), this.slotCapacity);
                this.onContentsChanged();
            }
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.checkIndex(slot);
        PSUSlot tmp = (PSUSlot)this.slots.get(slot);
        if (tmp.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack item = tmp.getStack();
        int extract = Math.min(amount, Math.min(tmp.getCount(), item.func_77976_d()));
        item.func_190920_e(extract);
        if (tmp.getCount() <= extract) {
            if (!simulate) {
                this.slots.set(slot, (Object)PSUSlot.EMPTY);
                this.onContentsChanged();
            }
        } else if (!simulate) {
            tmp.decrementCount(extract);
            this.onContentsChanged();
        }
        return item;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return !stack.func_77942_o() && !(stack.func_77973_b() instanceof PocketStorageUnit);
    }

    private void onContentsChanged() {
        StorageManager.get().func_76185_a();
    }

    public CompoundNBT serializeNBT() {
        ListNBT tagList = new ListNBT();
        for (PSUSlot slot : this.slots) {
            if (!slot.isEmpty()) {
                tagList.add((Object)slot.writeNBT());
                continue;
            }
            CompoundNBT tmp = new CompoundNBT();
            tmp.func_74778_a("Item", "");
            tmp.func_74768_a("Count", 0);
            tagList.add((Object)tmp);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Slots", (INBT)tagList);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("Slots")) {
            ListNBT tagList = nbt.func_150295_c("Slots", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT itemTag = tagList.func_150305_b(i);
                if (i >= this.slots.size()) continue;
                PSUSlot tmp = new PSUSlot(itemTag);
                this.slots.set(i, (Object)tmp);
            }
        }
    }
}

