/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.inventory;

import com.flanks255.psu.inventory.PSUItemHandler;
import com.flanks255.psu.items.PSUTier;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class PSUData {
    private final UUID uuid;
    private PSUTier tier;
    private final PSUItemHandler inventory;
    private final LazyOptional<IItemHandler> optional;
    public final Metadata meta = new Metadata();

    public PSUData(UUID uuidIn, PSUTier tierIn) {
        this.uuid = uuidIn;
        this.tier = tierIn;
        this.inventory = new PSUItemHandler(this.tier);
        this.optional = LazyOptional.of(() -> this.inventory);
    }

    public PSUData(UUID uuidIn, CompoundNBT incomingNBT) {
        this.uuid = uuidIn;
        this.tier = PSUTier.values()[Math.min(incomingNBT.func_74762_e("Tier"), PSUTier.TIER4.ordinal())];
        this.inventory = new PSUItemHandler(this.tier);
        this.inventory.deserializeNBT(incomingNBT.func_74775_l("Inventory"));
        this.optional = LazyOptional.of(() -> this.inventory);
        if (incomingNBT.func_74764_b("Metadata")) {
            this.meta.deserializeNBT(incomingNBT.func_74775_l("Metadata"));
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public LazyOptional<IItemHandler> getOptional() {
        return this.optional;
    }

    public PSUItemHandler getHandler() {
        return this.inventory;
    }

    public void upgrade(PSUTier newTier) {
        if (newTier.ordinal() > this.tier.ordinal()) {
            this.tier = newTier;
            this.inventory.upgrade(this.tier);
        }
    }

    public void updateAccessRecords(String player, long time) {
        if (this.meta.firstAccessedTime == 0L) {
            this.meta.firstAccessedTime = time;
            this.meta.firstAccessedPlayer = player;
        }
        this.meta.setLastAccessedTime(time);
        this.meta.setLastAccessedPlayer(player);
    }

    public PSUTier getTier() {
        return this.tier;
    }

    public static Optional<PSUData> fromNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("UUID")) {
            UUID uuid = nbt.func_186857_a("UUID");
            return Optional.of(new PSUData(uuid, nbt));
        }
        return Optional.empty();
    }

    public CompoundNBT toNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_186854_a("UUID", this.uuid);
        nbt.func_74778_a("StringUUID", this.uuid.toString());
        nbt.func_74768_a("Tier", this.tier.ordinal());
        nbt.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        nbt.func_218657_a("Metadata", (INBT)this.meta.serializeNBT());
        return nbt;
    }

    public static class Metadata
    implements INBTSerializable<CompoundNBT> {
        private String firstAccessedPlayer = "";
        private long firstAccessedTime = 0L;
        private String lastAccessedPlayer = "";
        private long lastAccessedTime = 0L;

        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public void setLastAccessedTime(long lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
        }

        public String getLastAccessedPlayer() {
            return this.lastAccessedPlayer;
        }

        public void setLastAccessedPlayer(String lastAccessedPlayer) {
            this.lastAccessedPlayer = lastAccessedPlayer;
        }

        public long getFirstAccessedTime() {
            return this.firstAccessedTime;
        }

        public String getFirstAccessedPlayer() {
            return this.firstAccessedPlayer;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("firstPlayer", this.firstAccessedPlayer);
            nbt.func_74772_a("firstTime", this.firstAccessedTime);
            nbt.func_74778_a("lastPlayer", this.lastAccessedPlayer);
            nbt.func_74772_a("lastTime", this.lastAccessedTime);
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.firstAccessedPlayer = nbt.func_74779_i("firstPlayer");
            this.firstAccessedTime = nbt.func_74763_f("firstTime");
            this.lastAccessedPlayer = nbt.func_74779_i("lastPlayer");
            this.lastAccessedTime = nbt.func_74763_f("lastTime");
        }
    }
}

