/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.gui;

import com.flanks255.psu.PocketStorage;
import com.flanks255.psu.gui.LockableSlot;
import com.flanks255.psu.inventory.PSUItemHandler;
import com.flanks255.psu.items.PSUTier;
import com.flanks255.psu.util.PSUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemHandlerHelper;

public class PSUContainer
extends Container {
    public PSUItemHandler handler;
    private final PlayerInventory playerInv;
    private final UUID uuid;

    public static PSUContainer fromNetwork(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        CompoundNBT nbt = data.func_244273_m();
        UUID uuidIn = data.func_179253_g();
        PSUTier tier = PSUTier.values()[data.readInt()];
        PSUItemHandler handler = new PSUItemHandler(tier);
        handler.deserializeNBT(nbt);
        return new PSUContainer(windowId, playerInventory, uuidIn, handler);
    }

    public PSUContainer(int windowId, PlayerInventory playerInventory, UUID uuidIn, PSUItemHandler handlerIn) {
        super((ContainerType)PocketStorage.PSUCONTAINER.get(), windowId);
        this.uuid = uuidIn;
        this.playerInv = playerInventory;
        this.handler = handlerIn;
        this.addPlayerSlots(playerInventory);
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (clickTypeIn == ClickType.SWAP) {
            return ItemStack.field_190927_a;
        }
        if (slot >= 0) {
            this.func_75139_a((int)slot).field_75224_c.func_70296_d();
        }
        return super.func_184996_a(slot, dragType, clickTypeIn, player);
    }

    public void networkSlotClick(int slot, boolean shift, boolean ctrl, boolean rightClick) {
        if (slot >= 0 && slot <= this.handler.getSlots()) {
            if (!this.playerInv.func_70445_o().func_190926_b()) {
                ItemStack tmp;
                ItemStack incoming = this.playerInv.func_70445_o();
                if (incoming.func_77942_o() && this.playerInv.field_70458_d.field_70170_p.func_201670_d()) {
                    this.playerInv.field_70458_d.func_145747_a((ITextComponent)new TranslationTextComponent("pocketstorage.util.no_data_items"), Util.field_240973_b_);
                    return;
                }
                if (rightClick) {
                    ItemStack single = incoming.func_77979_a(1);
                    ItemStack remainder = this.handler.insertItem(slot, single, false);
                    if (!remainder.func_190926_b()) {
                        incoming.func_190917_f(1);
                    }
                    this.playerInv.func_70437_b(incoming);
                } else if (!ctrl) {
                    this.playerInv.func_70437_b(this.handler.insertItem(slot, incoming, false));
                } else if (incoming.func_190916_E() < incoming.func_77976_d() && incoming.func_77969_a(this.handler.getStackInSlot(slot)) && !(tmp = this.handler.extractItem(slot, 1, false)).func_190926_b()) {
                    incoming.func_190920_e(incoming.func_190916_E() + 1);
                    this.playerInv.func_70437_b(incoming);
                }
            } else {
                int extract;
                int n = extract = ctrl ? 1 : 64;
                if (rightClick) {
                    extract = Math.min(this.handler.getStackInSlot(slot).func_190916_E() / 2, 32);
                }
                ItemStack tmp = this.handler.extractItem(slot, extract, false);
                if (!shift) {
                    if (!tmp.func_190926_b()) {
                        this.playerInv.func_70437_b(tmp);
                    }
                } else if (!tmp.func_190926_b()) {
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)this.playerInv.field_70458_d, (ItemStack)tmp);
                }
            }
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            return this.handler.insertItemSlotless(slot.func_75211_c(), true, true);
        }
        return ItemStack.field_190927_a;
    }

    private void addPlayerSlots(PlayerInventory playerInventory) {
        int originX = 7;
        int originY = 97;
        for (int col = 0; col < 9; ++col) {
            int x = originX + col * 18;
            int y = originY + 58;
            Optional<UUID> uuidOptional = PSUtils.getUUID((ItemStack)playerInventory.field_70462_a.get(col));
            boolean lockMe = uuidOptional.map(id -> id.compareTo(this.uuid) == 0).orElse(false);
            this.func_75146_a(new LockableSlot((IInventory)playerInventory, col, x + 1, y + 1, lockMe));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = originX + col * 18;
                int y = originY + row * 18;
                int index = col + row * 9 + 9;
                Optional<UUID> uuidOptional = PSUtils.getUUID((ItemStack)playerInventory.field_70462_a.get(index));
                boolean lockMe = uuidOptional.map(id -> id.compareTo(this.uuid) == 0).orElse(false);
                this.func_75146_a(new LockableSlot((IInventory)playerInventory, index, x + 1, y + 1, lockMe));
            }
        }
    }
}

