/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.psu.commands;

import com.flanks255.psu.gui.PSUContainer;
import com.flanks255.psu.inventory.PSUData;
import com.flanks255.psu.inventory.StorageManager;
import com.flanks255.psu.util.PSUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;

public class Open {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"open").requires(cs -> cs.func_197034_c(1))).then(Commands.func_197056_a((String)"UUID", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ISuggestionProvider.func_197005_b(PSUtils.getUUIDSuggestions((CommandContext<CommandSource>)context), (SuggestionsBuilder)builder)).executes(cs -> Open.open((CommandContext<CommandSource>)cs, StringArgumentType.getString((CommandContext)cs, (String)"UUID"))));
    }

    public static int open(CommandContext<CommandSource> ctx, String stringUUID) throws CommandSyntaxException {
        UUID uuid;
        try {
            uuid = UUID.fromString(stringUUID);
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
        StorageManager storageManager = StorageManager.get();
        if (storageManager.getMap().containsKey(uuid)) {
            ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
            Optional<PSUData> data = storageManager.getStorage(uuid);
            data.ifPresent(psu -> NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, playerEntity) -> new PSUContainer(windowId, playerInventory, uuid, psu.getHandler()), (ITextComponent)new StringTextComponent(psu.getTier().name)), packetBuffer -> packetBuffer.func_150786_a(psu.getHandler().serializeNBT()).func_179252_a(uuid).writeInt(psu.getTier().ordinal())));
        } else {
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("pocketstorage.util.invalid_uuid"));
        }
        return 0;
    }
}

