/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.bcc;

import com.google.gson.Gson;
import dev.wuffs.bcc.Config;
import dev.wuffs.bcc.Metadata;
import dev.wuffs.bcc.PingData;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bcc")
public class BCC {
    public static final String MODID = "bcc";
    private static final Logger LOGGER = LogManager.getLogger((String)"Better Compatability Checker (bcc)");
    public static PingData localPingData = new PingData();

    public static Logger getLogger() {
        return LOGGER;
    }

    public BCC() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doCommonSetup);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    private void doCommonSetup(FMLCommonSetupEvent event) {
        if (((Boolean)Config.useMetadata.get()).booleanValue()) {
            Path metaFile = FMLPaths.CONFIGDIR.get().resolve("metadata.json");
            if (!Files.exists(metaFile, new LinkOption[0])) {
                LOGGER.error("No metadata.json found, falling back to config values");
            } else {
                try {
                    LOGGER.info("Loading metadata.json");
                    Metadata metadata = (Metadata)new Gson().fromJson((Reader)Files.newBufferedReader(metaFile), Metadata.class);
                    BCC.localPingData.projectID = metadata.id;
                    BCC.localPingData.name = metadata.name;
                    BCC.localPingData.version = metadata.version.name;
                    BCC.localPingData.versionID = metadata.version.id;
                    BCC.localPingData.releaseType = metadata.version.type;
                    BCC.localPingData.isMetadata = true;
                    return;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to read metadata.json", (Throwable)e);
                }
            }
        }
        BCC.localPingData.projectID = (Integer)Config.modpackProjectID.get();
        BCC.localPingData.name = (String)Config.modpackName.get();
        BCC.localPingData.version = (String)Config.modpackVersion.get();
    }

    public static boolean comparePingData(PingData pingData) {
        return pingData.projectID == BCC.localPingData.projectID && pingData.name.equals(BCC.localPingData.name) && pingData.version.equals(BCC.localPingData.version);
    }
}

