/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityPlatypus;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PlatypusAIDigForItems
extends Goal {
    public static final ResourceLocation PLATYPUS_REWARD = new ResourceLocation("alexsmobs", "gameplay/platypus_reward");
    public static final ResourceLocation PLATYPUS_REWARD_CHARGED = new ResourceLocation("alexsmobs", "gameplay/platypus_supercharged_reward");
    private EntityPlatypus platypus;
    private BlockPos digPos;
    private int generatePosCooldown = 0;
    private int digTime = 0;
    private int maxDroppedItems = 3;

    public PlatypusAIDigForItems(EntityPlatypus platypus) {
        this.platypus = platypus;
    }

    private static List<ItemStack> getItemStacks(EntityPlatypus platypus) {
        LootTable loottable = platypus.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(platypus.superCharged ? PLATYPUS_REWARD_CHARGED : PLATYPUS_REWARD);
        return loottable.func_216113_a(new LootContext.Builder((ServerWorld)platypus.field_70170_p).func_216015_a(LootParameters.field_216281_a, (Object)platypus).func_216023_a(platypus.field_70170_p.field_73012_v).func_216022_a(LootParameterSets.field_237453_h_));
    }

    public boolean func_75250_a() {
        if (!this.platypus.isSensing()) {
            return false;
        }
        if (this.generatePosCooldown == 0) {
            this.generatePosCooldown = 20 + this.platypus.func_70681_au().nextInt(20);
            this.digPos = this.genDigPos();
            this.maxDroppedItems = 2 + this.platypus.func_70681_au().nextInt(5);
            return this.digPos != null;
        }
        --this.generatePosCooldown;
        return false;
    }

    public boolean func_75253_b() {
        return this.platypus.func_70638_az() == null && this.platypus.isSensing() && this.platypus.func_70643_av() == null && this.digPos != null && this.platypus.field_70170_p.func_180495_p(this.digPos).func_177230_c() == Blocks.field_150435_aG && this.platypus.field_70170_p.func_204610_c(this.digPos.func_177984_a()).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public void func_75246_d() {
        double dist = this.platypus.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.digPos.func_177984_a()));
        double d0 = (double)this.digPos.func_177958_n() + 0.5 - this.platypus.func_226277_ct_();
        double d1 = (double)this.digPos.func_177956_o() + 0.5 - this.platypus.func_226280_cw_();
        double d2 = (double)this.digPos.func_177952_p() + 0.5 - this.platypus.func_226281_cx_();
        float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        if (dist < 2.0) {
            List<ItemStack> lootList;
            int itemDivis;
            this.platypus.func_213317_d(this.platypus.func_213322_ci().func_72441_c(0.0, (double)-0.01f, 0.0));
            this.platypus.func_70661_as().func_75499_g();
            ++this.digTime;
            if (this.digTime % 5 == 0) {
                SoundEvent sound = this.platypus.field_70170_p.func_180495_p(this.digPos).func_215695_r().func_185846_f();
                this.platypus.func_184185_a(sound, 1.0f, 0.5f + this.platypus.func_70681_au().nextFloat() * 0.5f);
            }
            if (this.digTime % (itemDivis = (int)Math.floor(100.0f / (float)this.maxDroppedItems)) == 0 && (lootList = PlatypusAIDigForItems.getItemStacks(this.platypus)).size() > 0) {
                for (ItemStack stack : lootList) {
                    ItemEntity e = this.platypus.func_199701_a_(stack.func_77946_l());
                    e.field_70160_al = true;
                    e.func_213317_d(e.func_213322_ci().func_216372_d(0.2, 0.2, 0.2));
                }
            }
            if (this.digTime >= 100) {
                this.platypus.setSensing(false);
                this.platypus.setDigging(false);
                this.digTime = 0;
            } else {
                this.platypus.setDigging(true);
            }
        } else {
            this.platypus.setDigging(false);
            this.platypus.func_70661_as().func_75492_a((double)this.digPos.func_177958_n(), (double)(this.digPos.func_177956_o() + 1), (double)this.digPos.func_177952_p(), 1.0);
            this.platypus.field_70177_z = f;
        }
    }

    public void func_75251_c() {
        this.generatePosCooldown = 0;
        this.platypus.setSensing(false);
        this.platypus.setDigging(false);
        this.digPos = null;
        this.digTime = 0;
    }

    private BlockPos genSeafloorPos(BlockPos parent) {
        World world = this.platypus.field_70170_p;
        Random random = new Random();
        int range = 15;
        for (int i = 0; i < 15; ++i) {
            BlockPos seafloor = parent.func_177982_a(random.nextInt(range) - range / 2, 0, random.nextInt(range) - range / 2);
            while (world.func_204610_c(seafloor).func_206884_a((ITag)FluidTags.field_206959_a) && seafloor.func_177956_o() > 1) {
                seafloor = seafloor.func_177977_b();
            }
            BlockState state = world.func_180495_p(seafloor);
            if (state.func_177230_c() != Blocks.field_150435_aG) continue;
            return seafloor;
        }
        return null;
    }

    private BlockPos genDigPos() {
        Random random = new Random();
        int range = 15;
        if (this.platypus.func_70090_H()) {
            return this.genSeafloorPos(this.platypus.func_233580_cy_());
        }
        for (int i = 0; i < 15; ++i) {
            BlockPos pos3;
            BlockPos blockpos1 = this.platypus.func_233580_cy_().func_177982_a(random.nextInt(range) - range / 2, 3, random.nextInt(range) - range / 2);
            while (this.platypus.field_70170_p.func_175623_d(blockpos1) && blockpos1.func_177956_o() > 1) {
                blockpos1 = blockpos1.func_177977_b();
            }
            if (!this.platypus.field_70170_p.func_204610_c(blockpos1).func_206884_a((ITag)FluidTags.field_206959_a) || (pos3 = this.genSeafloorPos(blockpos1)) == null) continue;
            return pos3;
        }
        return null;
    }
}

