/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.part;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartStateBase;
import org.cyclops.integratedtunnels.core.part.ContainerInterfaceSettings;
import org.cyclops.integratedtunnels.core.part.IPartTypeInterfacePositionedAddon;
import org.cyclops.integratedtunnels.core.part.PartTypeTunnel;

public abstract class PartTypeInterfacePositionedAddon<N extends IPositionedAddonsNetwork, T, P extends PartTypeInterfacePositionedAddon<N, T, P, S>, S extends IPartTypeInterfacePositionedAddon.IState<N, T, P, S>>
extends PartTypeTunnel<P, S>
implements IPartTypeInterfacePositionedAddon<N, T, P, S> {
    public PartTypeInterfacePositionedAddon(String name) {
        super(name);
    }

    public boolean isUpdate(S state) {
        return this.getConsumptionRate((IPartState)state) > 0 && GeneralConfig.energyConsumptionMultiplier > 0;
    }

    public Optional<INamedContainerProvider> getContainerProvider(final PartPos pos) {
        return Optional.of(new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent(PartTypeInterfacePositionedAddon.this.getTranslationKey());
            }

            @Nullable
            public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                return new ContainerInterfaceSettings(id, playerInventory, (IInventory)new Inventory(0), (PartTarget)data.getRight(), Optional.of(data.getLeft()), (IPartType)data.getMiddle());
            }
        });
    }

    public void writeExtraGuiData(PacketBuffer packetBuffer, PartPos pos, ServerPlayerEntity player) {
        PacketCodec.write((PacketBuffer)packetBuffer, (Object)pos);
        packetBuffer.func_180714_a(this.getUniqueName().toString());
    }

    @Override
    public void onAddingPositionToNetwork(N networkCapability, INetwork network, PartPos pos, int priority, int channelInterface, S state) {
        networkCapability.addPosition(pos, priority, channelInterface);
    }

    @Override
    public void onRemovingPositionFromNetwork(N networkCapability, INetwork network, PartPos pos, S state) {
        networkCapability.removePosition(pos);
    }

    public void afterNetworkReAlive(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.afterNetworkReAlive(network, partNetwork, target, state);
        this.addTargetToNetwork(network, target.getTarget(), state.getPriority(), state.getChannelInterface(), (IPartTypeInterfacePositionedAddon.IState)state);
    }

    public void onNetworkRemoval(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.onNetworkRemoval(network, partNetwork, target, state);
        this.scheduleNetworkObservation(target, (IPartTypeInterfacePositionedAddon.IState)state);
        this.removeTargetFromNetwork(network, target.getTarget(), (IPartTypeInterfacePositionedAddon.IState)state);
    }

    public void onNetworkAddition(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.onNetworkAddition(network, partNetwork, target, state);
        this.addTargetToNetwork(network, target.getTarget(), state.getPriority(), state.getChannelInterface(), (IPartTypeInterfacePositionedAddon.IState)state);
        this.scheduleNetworkObservation(target, (IPartTypeInterfacePositionedAddon.IState)state);
    }

    public void onBlockNeighborChange(INetwork network, IPartNetwork partNetwork, PartTarget target, S state, IBlockReader world, Block neighbourBlock, BlockPos neighbourBlockPos) {
        super.onBlockNeighborChange(network, partNetwork, target, state, world, neighbourBlock, neighbourBlockPos);
        if (network != null) {
            this.updateTargetInNetwork(network, target.getTarget(), state.getPriority(), state.getChannelInterface(), (IPartTypeInterfacePositionedAddon.IState)state);
        }
    }

    public void setPriorityAndChannel(INetwork network, IPartNetwork partNetwork, PartTarget target, S state, int priority, int channel) {
        this.removeTargetFromNetwork(network, target.getTarget(), (IPartTypeInterfacePositionedAddon.IState)state);
        super.setPriorityAndChannel(network, partNetwork, target, state, priority, channel);
        this.addTargetToNetwork(network, target.getTarget(), priority, state.getChannelInterface(), (IPartTypeInterfacePositionedAddon.IState)state);
    }

    public static abstract class State<N extends IPositionedAddonsNetwork, T, P extends PartTypeInterfacePositionedAddon<N, T, P, S>, S extends State<N, T, P, S>>
    extends PartStateBase<P>
    implements IPartTypeInterfacePositionedAddon.IState<N, T, P, S> {
        private N positionedAddonsNetwork = null;
        private PartPos pos = null;
        private boolean validTargetCapability = false;
        private int channelInterface = 0;
        private INetwork network;
        private IPartNetwork partNetwork;

        public void readFromNBT(CompoundNBT tag) {
            super.readFromNBT(tag);
            if (tag.func_150297_b("channelInterface", 3)) {
                this.channelInterface = tag.func_74762_e("channelInterface");
            }
        }

        public void writeToNBT(CompoundNBT tag) {
            super.writeToNBT(tag);
            tag.func_74768_a("channelInterface", this.channelInterface);
        }

        @Override
        public void setChannelInterface(int channelInterface) {
            this.channelInterface = channelInterface;
            this.sendUpdate();
        }

        @Override
        public int getChannelInterface() {
            return this.channelInterface;
        }

        @Override
        @Nullable
        public N getPositionedAddonsNetwork() {
            return this.positionedAddonsNetwork;
        }

        @Override
        public void setPositionedAddonsNetwork(N positionedAddonsNetwork) {
            this.positionedAddonsNetwork = positionedAddonsNetwork;
        }

        @Override
        public boolean isValidTargetCapability() {
            return this.validTargetCapability;
        }

        @Override
        public void setValidTargetCapability(boolean validTargetCapability) {
            this.validTargetCapability = validTargetCapability;
        }

        @Override
        public PartPos getPos() {
            return this.pos;
        }

        @Override
        public void setPos(PartPos pos) {
            this.pos = pos;
        }

        @Override
        public void setNetworks(@Nullable INetwork network, @Nullable IPartNetwork partNetwork) {
            this.network = network;
            this.partNetwork = partNetwork;
        }

        @Override
        @Nullable
        public INetwork getNetwork() {
            return this.network;
        }

        @Override
        @Nullable
        public IPartNetwork getPartNetwork() {
            return this.partNetwork;
        }

        public <T2> LazyOptional<T2> getCapability(Capability<T2> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
            if (this.isNetworkAndPositionValid() && capability == this.getTargetCapability()) {
                return LazyOptional.of(this::getCapabilityInstance).cast();
            }
            return super.getCapability(capability, network, partNetwork, target);
        }
    }
}

