/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.util;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import xreliquary.items.util.FilteredBigItemStack;
import xreliquary.items.util.FilteredItemStackHandler;
import xreliquary.reference.Settings;

public class VoidTearItemStackHandler
extends FilteredItemStackHandler {
    private static final int FIRST_SLOT = 0;

    public VoidTearItemStackHandler() {
        super(new ArrayList<FilteredItemStackHandler.RemovableStack>());
    }

    public void setContainedStack(ItemStack stack) {
        this.setBigStack(0, new FilteredItemStackHandler.RemovableStack(new FilteredBigItemStack(stack, (int)((Integer)Settings.COMMON.items.voidTear.itemLimit.get())), true));
    }

    public void setContainedStackAmount(int amount) {
        this.setTotalAmount(0, amount);
    }

    public ItemStack getTotalAmountStack() {
        FilteredBigItemStack bigStack = this.getBigStack(0);
        return ItemHandlerHelper.copyStackWithSize((ItemStack)bigStack.getOutputStack().func_77946_l(), (int)bigStack.getAmount());
    }

    @Override
    protected boolean isValidForBigStackSlot(ItemStack stack, int bigStackSlot) {
        return bigStackSlot == 0 && super.isValidForBigStackSlot(stack, bigStackSlot);
    }

    public int getContainedAmount() {
        return this.getTotalAmount(0);
    }
}

