/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.init;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import xreliquary.entities.EnderStaffProjectileEntity;
import xreliquary.entities.GlowingWaterEntity;
import xreliquary.entities.HolyHandGrenadeEntity;
import xreliquary.entities.KrakenSlimeEntity;
import xreliquary.entities.LyssaBobberEntity;
import xreliquary.entities.SpecialSnowballEntity;
import xreliquary.entities.XRTippedArrowEntity;
import xreliquary.entities.potion.AttractionPotionEntity;
import xreliquary.entities.potion.FertilePotionEntity;
import xreliquary.entities.potion.ThrownXRPotionEntity;
import xreliquary.entities.shot.BlazeShotEntity;
import xreliquary.entities.shot.BusterShotEntity;
import xreliquary.entities.shot.ConcussiveShotEntity;
import xreliquary.entities.shot.EnderShotEntity;
import xreliquary.entities.shot.ExorcismShotEntity;
import xreliquary.entities.shot.NeutralShotEntity;
import xreliquary.entities.shot.SandShotEntity;
import xreliquary.entities.shot.SeekerShotEntity;
import xreliquary.entities.shot.ShotEntityBase;
import xreliquary.entities.shot.StormShotEntity;
import xreliquary.util.InjectionHelper;

@Mod.EventBusSubscriber(modid="xreliquary", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="xreliquary")
public class ModEntities {
    public static final EntityType<AttractionPotionEntity> APHRODITE_POTION = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<FertilePotionEntity> FERTILE_POTION = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<ThrownXRPotionEntity> THROWN_POTION = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<BlazeShotEntity> BLAZE_SHOT = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<BusterShotEntity> BUSTER_SHOT = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<ConcussiveShotEntity> CONCUSSIVE_SHOT = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<EnderShotEntity> ENDER_SHOT = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<ExorcismShotEntity> EXORCISM_SHOT = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<NeutralShotEntity> NEUTRAL_SHOT = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<SandShotEntity> SAND_SHOT = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<SeekerShotEntity> SEEKER_SHOT = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<StormShotEntity> STORM_SHOT = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<EnderStaffProjectileEntity> ENDER_STAFF_PROJECTILE = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<GlowingWaterEntity> GLOWING_WATER = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<HolyHandGrenadeEntity> HOLY_HAND_GRENADE = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<KrakenSlimeEntity> KRAKEN_SLIME = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<LyssaBobberEntity> LYSSA_HOOK = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<XRTippedArrowEntity> TIPPED_ARROW = (EntityType)InjectionHelper.nullValue();
    public static final EntityType<SpecialSnowballEntity> SPECIAL_SNOWBALL = (EntityType)InjectionHelper.nullValue();

    private ModEntities() {
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> evt) {
        IForgeRegistry registry = evt.getRegistry();
        ModEntities.registerDefaultSizeEntity(registry, AttractionPotionEntity::new, "aphrodite_potion");
        ModEntities.registerDefaultSizeEntity(registry, FertilePotionEntity::new, "fertile_potion");
        ModEntities.registerDefaultSizeEntity(registry, ThrownXRPotionEntity::new, "thrown_potion");
        ModEntities.registerShotEntity(registry, BlazeShotEntity::new, "blaze_shot");
        ModEntities.registerShotEntity(registry, BusterShotEntity::new, "buster_shot");
        ModEntities.registerShotEntity(registry, ConcussiveShotEntity::new, "concussive_shot");
        ModEntities.registerShotEntity(registry, EnderShotEntity::new, "ender_shot");
        ModEntities.registerShotEntity(registry, ExorcismShotEntity::new, "exorcism_shot");
        ModEntities.registerShotEntity(registry, NeutralShotEntity::new, "neutral_shot");
        ModEntities.registerShotEntity(registry, SandShotEntity::new, "sand_shot");
        ModEntities.registerShotEntity(registry, SeekerShotEntity::new, "seeker_shot");
        ModEntities.registerShotEntity(registry, StormShotEntity::new, "storm_shot");
        ModEntities.registerEntity(registry, EnderStaffProjectileEntity::new, "ender_staff_projectile", 0.25f, 0.25f, 256);
        ModEntities.registerDefaultSizeEntity(registry, GlowingWaterEntity::new, "glowing_water");
        ModEntities.registerDefaultSizeEntity(registry, HolyHandGrenadeEntity::new, "holy_hand_grenade");
        ModEntities.registerDefaultSizeEntity(registry, KrakenSlimeEntity::new, "kraken_slime");
        ModEntities.registerDefaultSizeEntity(registry, LyssaBobberEntity::new, "lyssa_hook");
        ModEntities.registerDefaultSizeEntity(registry, XRTippedArrowEntity::new, "tipped_arrow");
        ModEntities.registerEntity(registry, SpecialSnowballEntity::new, "special_snowball", 0.01f, 0.01f);
    }

    private static <T extends Entity> void registerDefaultSizeEntity(IForgeRegistry<EntityType<?>> registry, EntityType.IFactory<T> factory, String registryName) {
        ModEntities.registerEntity(registry, factory, registryName, 0.25f, 0.25f);
    }

    private static <T extends ShotEntityBase> void registerShotEntity(IForgeRegistry<EntityType<?>> registry, EntityType.IFactory<T> factory, String registryName) {
        ModEntities.registerEntity(registry, factory, registryName, 0.01f, 0.01f);
    }

    private static <T extends Entity> void registerEntity(IForgeRegistry<EntityType<?>> registry, EntityType.IFactory<T> factory, String registryName, float width, float height) {
        ModEntities.registerEntity(registry, factory, registryName, width, height, 128);
    }

    private static <T extends Entity> void registerEntity(IForgeRegistry<EntityType<?>> registry, EntityType.IFactory<T> factory, String registryName, float width, float height, int trackingRange) {
        registry.register((IForgeRegistryEntry)((EntityType)EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.MISC).func_220321_a(width, height).setUpdateInterval(5).setTrackingRange(trackingRange).setShouldReceiveVelocityUpdates(true).func_206830_a("").setRegistryName(new ResourceLocation("xreliquary", registryName))));
    }
}

