/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xreliquary.crafting.AlkahestryRecipeRegistry;
import xreliquary.init.ModItems;
import xreliquary.items.AlkahestryTomeItem;
import xreliquary.reference.Settings;

public class AlkahestryCraftingRecipe
implements ICraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final Ingredient craftingIngredient;
    private final int chargeNeeded;
    private final int resultCount;
    private final ItemStack result;
    private final ResourceLocation id;
    private final Ingredient tomeIngredient;

    private AlkahestryCraftingRecipe(ResourceLocation id, Ingredient craftingIngredient, int chargeNeeded, int resultCount) {
        this.id = id;
        this.craftingIngredient = craftingIngredient;
        this.chargeNeeded = chargeNeeded;
        this.tomeIngredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{AlkahestryTomeItem.setCharge(new ItemStack((IItemProvider)ModItems.ALKAHESTRY_TOME.get()), (Integer)Settings.COMMON.items.alkahestryTome.chargeLimit.get())});
        this.resultCount = resultCount;
        this.result = craftingIngredient.func_193365_a()[0].func_77946_l();
        this.result.func_190920_e(resultCount);
        AlkahestryRecipeRegistry.registerCraftingRecipe(this);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        boolean hasIngredient = false;
        boolean hasTome = false;
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack slotStack = inv.func_70301_a(x);
            if (slotStack.func_190926_b()) continue;
            boolean inRecipe = false;
            if (this.craftingIngredient.test(slotStack)) {
                inRecipe = true;
                hasIngredient = true;
            } else if (!hasTome && slotStack.func_77973_b() == ModItems.ALKAHESTRY_TOME.get() && AlkahestryTomeItem.getCharge(slotStack) >= this.chargeNeeded) {
                inRecipe = true;
                hasTome = true;
            }
            if (inRecipe) continue;
            return false;
        }
        return hasIngredient && hasTome;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.craftingIngredient, this.tomeIngredient});
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_190926_b() || stack.func_77973_b() == ModItems.ALKAHESTRY_TOME.get()) continue;
            ItemStack craftingResult = stack.func_77946_l();
            craftingResult.func_190920_e(this.resultCount);
            return craftingResult;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public Ingredient getCraftingIngredient() {
        return this.craftingIngredient;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList remainingItems = super.func_179532_b((IInventory)inv);
        this.addTomeWithUsedCharge((NonNullList<ItemStack>)remainingItems, inv);
        return remainingItems;
    }

    private void addTomeWithUsedCharge(NonNullList<ItemStack> remainingItems, CraftingInventory inv) {
        for (int slot = 0; slot < remainingItems.size(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_77973_b() != ModItems.ALKAHESTRY_TOME.get()) continue;
            ItemStack tome = stack.func_77946_l();
            ((AlkahestryTomeItem)ModItems.ALKAHESTRY_TOME.get()).useCharge(tome, this.chargeNeeded);
            remainingItems.set(slot, (Object)tome);
            break;
        }
    }

    public boolean func_192399_d() {
        return true;
    }

    public int getChargeNeeded() {
        return this.chargeNeeded;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AlkahestryCraftingRecipe> {
        public AlkahestryCraftingRecipe read(ResourceLocation recipeId, JsonObject json) {
            if (!json.has("ingredient")) {
                throw new JsonParseException("No ingredient for alkahestry crafting recipe");
            }
            Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)json.get("ingredient"));
            int resultCount = JSONUtils.func_151203_m((JsonObject)json, (String)"result_count");
            int chargeNeeded = JSONUtils.func_151203_m((JsonObject)json, (String)"charge");
            return new AlkahestryCraftingRecipe(recipeId, ingredient, chargeNeeded, resultCount);
        }

        @Nullable
        public AlkahestryCraftingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new AlkahestryCraftingRecipe(recipeId, Ingredient.func_199566_b((PacketBuffer)buffer), buffer.readInt(), buffer.readInt());
        }

        public void write(PacketBuffer buffer, AlkahestryCraftingRecipe recipe) {
            recipe.craftingIngredient.func_199564_a(buffer);
            buffer.writeInt(recipe.chargeNeeded);
            buffer.writeInt(recipe.resultCount);
        }
    }
}

