/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.items;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.gui.FilterContainer;
import com.flanks255.simplybackpacks.gui.SBContainer;
import com.flanks255.simplybackpacks.inventory.BackpackData;
import com.flanks255.simplybackpacks.inventory.BackpackManager;
import com.flanks255.simplybackpacks.inventory.FilterItemHandler;
import com.flanks255.simplybackpacks.inventory.SBItemHandler;
import com.flanks255.simplybackpacks.items.Backpack;
import com.flanks255.simplybackpacks.network.ToggleMessageMessage;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BackpackItem
extends Item {
    final String name;
    final Backpack tier;

    public BackpackItem(String name, Backpack tier) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i).func_234689_a_());
        this.name = name;
        this.tier = tier;
    }

    public static Backpack getTier(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof BackpackItem) {
            return ((BackpackItem)stack.func_77973_b()).tier;
        }
        return Backpack.COMMON;
    }

    public static BackpackData getData(ItemStack stack) {
        UUID uuid;
        if (!(stack.func_77973_b() instanceof BackpackItem)) {
            return null;
        }
        CompoundNBT tag = stack.func_196082_o();
        if (!tag.func_74764_b("UUID")) {
            uuid = UUID.randomUUID();
            tag.func_186854_a("UUID", uuid);
        } else {
            uuid = tag.func_186857_a("UUID");
        }
        return BackpackManager.get().getOrCreateBackpack(uuid, ((BackpackItem)stack.func_77973_b()).tier);
    }

    public static boolean isBackpack(ItemStack stack) {
        return stack.func_77973_b() instanceof BackpackItem;
    }

    @Nonnull
    public Rarity func_77613_e(@Nonnull ItemStack stack) {
        return this.tier.rarity;
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        return new TranslationTextComponent(this.func_77667_c(stack)).func_240699_a_(this.tier == Backpack.ULTIMATE ? TextFormatting.DARK_AQUA : TextFormatting.RESET);
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.isIn(SimplyBackpacks.SOULBOUND);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        ItemStack backpack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && playerIn instanceof ServerPlayerEntity && backpack.func_77973_b() instanceof BackpackItem) {
            BackpackData data = BackpackItem.getData(backpack);
            if (backpack.func_196082_o().func_74764_b("Inventory")) {
                if (backpack.func_77978_p().func_74775_l("Inventory").func_74764_b("Size")) {
                    backpack.func_77978_p().func_74775_l("Inventory").func_82580_o("Size");
                }
                ((SBItemHandler)data.getHandler()).deserializeNBT(backpack.func_77978_p().func_74775_l("Inventory"));
                if (backpack.func_77978_p().func_74764_b("Filter")) {
                    data.getFilter().deserializeNBT(backpack.func_77978_p().func_74775_l("Filter"));
                    backpack.func_77978_p().func_82580_o("Filter");
                }
                playerIn.func_145747_a((ITextComponent)new StringTextComponent("Backpack Migrated"), Util.field_240973_b_);
                backpack.func_77978_p().func_82580_o("Inventory");
            }
            Backpack itemTier = ((BackpackItem)backpack.func_77973_b()).tier;
            UUID uuid = data.getUuid();
            data.updateAccessRecords(playerIn.func_200200_C_().getString(), System.currentTimeMillis());
            if (data.getTier().ordinal() < itemTier.ordinal()) {
                data.upgrade(itemTier);
            }
            if (playerIn.func_225608_bj_()) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, playerEntity) -> new FilterContainer(windowId, playerInventory, data.getFilter()), backpack.func_200301_q()), buffer -> buffer.func_150786_a(data.getFilter().serializeNBT()));
            } else {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, playerEntity) -> new SBContainer(windowId, playerInventory, uuid, data.getTier(), data.getHandler()), backpack.func_200301_q()), buffer -> buffer.func_179252_a(uuid).writeInt(data.getTier().ordinal()));
            }
        }
        return ActionResult.func_226248_a_((Object)playerIn.func_184586_b(handIn));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new BackpackCaps(stack);
    }

    public static void togglePickup(PlayerEntity playerEntity, ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        boolean Pickup = !nbt.func_74767_n("Pickup");
        nbt.func_74757_a("Pickup", Pickup);
        if (playerEntity instanceof ServerPlayerEntity) {
            SimplyBackpacks.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)playerEntity), (Object)new ToggleMessageMessage(Pickup));
        } else {
            playerEntity.func_146105_b((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)(Pickup ? "simplybackpacks.autopickupenabled" : "simplybackpacks.autopickupdisabled"), (Object[])new Object[0])), true);
        }
    }

    public static boolean applyFilter(ItemStack item, ItemStack packItem) {
        LazyOptional handlerOptional = packItem.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (handlerOptional.isPresent() && handlerOptional.resolve().get() instanceof SBItemHandler) {
            BackpackData data = BackpackItem.getData(packItem);
            if (data == null) {
                return false;
            }
            FilterItemHandler filterHandler = data.getFilter();
            int filterOpts = packItem.func_196082_o().func_74762_e("Filter-OPT");
            boolean whitelist = (filterOpts & 1) > 0;
            boolean nbtMatch = (filterOpts & 2) > 0;
            for (int i = 0; i < 16; ++i) {
                ItemStack fStack = filterHandler.getStackInSlot(i);
                if (fStack.func_190926_b() || !fStack.func_77969_a(item)) continue;
                if (nbtMatch) {
                    return ItemStack.func_77970_a((ItemStack)fStack, (ItemStack)item) == whitelist;
                }
                return whitelist;
            }
            return !whitelist;
        }
        return false;
    }

    public static boolean pickupEvent(EntityItemPickupEvent event, ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            return false;
        }
        if (!nbt.func_74767_n("Pickup")) {
            return false;
        }
        LazyOptional optional = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (optional.isPresent()) {
            IItemHandler handler = (IItemHandler)optional.resolve().get();
            if (!(handler instanceof SBItemHandler)) {
                return false;
            }
            if (!BackpackItem.applyFilter(event.getItem().func_92059_d(), stack)) {
                return false;
            }
            ItemStack pickedUp = event.getItem().func_92059_d();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack slot = handler.getStackInSlot(i);
                if (!slot.func_190926_b() && (!ItemHandlerHelper.canItemStacksStack((ItemStack)slot, (ItemStack)pickedUp) || slot.func_190916_E() >= slot.func_77976_d() || slot.func_190916_E() >= handler.getSlotLimit(i))) continue;
                int remainder = handler.insertItem(i, pickedUp.func_77946_l(), false).func_190916_E();
                pickedUp.func_190920_e(remainder);
                if (remainder == 0) break;
            }
            return pickedUp.func_190926_b();
        }
        return false;
    }

    private boolean hasTranslation(String key) {
        return !I18n.func_135052_a((String)key, (Object[])new Object[0]).equals(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String translationKey = this.func_77658_a();
        boolean pickupEnabled = stack.func_196082_o().func_74767_n("Pickup");
        if (pickupEnabled) {
            tooltip.add((ITextComponent)new TranslationTextComponent("simplybackpacks.autopickupenabled"));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("simplybackpacks.autopickupdisabled"));
        }
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent(translationKey + ".info"));
            if (this.hasTranslation(translationKey + ".info2")) {
                tooltip.add((ITextComponent)new TranslationTextComponent(translationKey + ".info2"));
            }
            if (this.hasTranslation(translationKey + ".info3")) {
                tooltip.add((ITextComponent)new TranslationTextComponent(translationKey + ".info3"));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("simplybackpacks.shift"));
        }
        if (flagIn.func_194127_a() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("UUID")) {
            UUID uuid = stack.func_77978_p().func_186857_a("UUID");
            tooltip.add((ITextComponent)new StringTextComponent("ID: " + uuid.toString().substring(0, 8)).func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
        }
    }

    static class BackpackCaps
    implements ICapabilityProvider {
        private final ItemStack stack;
        private LazyOptional<IItemHandler> optional = LazyOptional.empty();

        public BackpackCaps(ItemStack stack) {
            this.stack = stack;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                if (!this.optional.isPresent()) {
                    this.optional = BackpackManager.get().getCapability(this.stack);
                }
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }
    }
}

