/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.gui;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.gui.LockableSlot;
import com.flanks255.simplybackpacks.gui.SBContainerSlot;
import com.flanks255.simplybackpacks.items.Backpack;
import com.flanks255.simplybackpacks.util.BackpackUtils;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class SBContainer
extends Container {
    public final IItemHandler handler;
    private final Backpack tier;
    private final UUID uuid;

    public static SBContainer fromNetwork(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        UUID uuidIn = data.func_179253_g();
        Backpack tier = Backpack.values()[data.readInt()];
        return new SBContainer(windowId, playerInventory, uuidIn, tier, (IItemHandler)new ItemStackHandler(tier.slots));
    }

    public SBContainer(int windowId, PlayerInventory playerInventory, UUID uuidIn, Backpack tierIn, IItemHandler handler) {
        super((ContainerType)SimplyBackpacks.SBCONTAINER.get(), windowId);
        this.uuid = uuidIn;
        this.handler = handler;
        this.tier = tierIn;
        this.addPlayerSlots(playerInventory);
        this.addMySlots();
    }

    public Backpack getTier() {
        return this.tier;
    }

    public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        return true;
    }

    @Nonnull
    public ItemStack func_184996_a(int slot, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull PlayerEntity player) {
        if (clickTypeIn == ClickType.SWAP) {
            return ItemStack.field_190927_a;
        }
        if (slot >= 0) {
            this.func_75139_a((int)slot).field_75224_c.func_70296_d();
        }
        return super.func_184996_a(slot, dragType, clickTypeIn, player);
    }

    private void addPlayerSlots(PlayerInventory playerInventory) {
        int originX = this.tier.slotXOffset;
        int originY = this.tier.slotYOffset;
        for (int col = 0; col < 9; ++col) {
            int x = originX + col * 18;
            int y = originY + 58;
            Optional<UUID> uuidOptional = BackpackUtils.getUUID((ItemStack)playerInventory.field_70462_a.get(col));
            boolean lockMe = uuidOptional.map(id -> id.compareTo(this.uuid) == 0).orElse(false);
            this.func_75146_a(new LockableSlot((IInventory)playerInventory, col, x + 1, y + 1, lockMe));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = originX + col * 18;
                int y = originY + row * 18;
                int index = col + row * 9 + 9;
                Optional<UUID> uuidOptional = BackpackUtils.getUUID((ItemStack)playerInventory.field_70462_a.get(index));
                boolean lockMe = uuidOptional.map(id -> id.compareTo(this.uuid) == 0).orElse(false);
                this.func_75146_a(new LockableSlot((IInventory)playerInventory, index, x + 1, y + 1, lockMe));
            }
        }
    }

    private void addMySlots() {
        if (this.handler == null) {
            return;
        }
        int cols = this.tier.slotCols;
        int rows = this.tier.slotRows;
        int slot_index = 0;
        block0: for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                int x = 7 + col * 18;
                int y = 17 + row * 18;
                if (row > 7 && col > 2 && col < 13 && this.tier == Backpack.ULTIMATE) continue;
                this.func_75146_a((Slot)new SBContainerSlot(this.handler, slot_index, x + 1, y + 1));
                if (++slot_index >= this.tier.slots) continue block0;
            }
        }
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            int bagslotcount = this.field_75151_b.size();
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < playerIn.field_71071_by.field_70462_a.size() ? !this.func_75135_a(itemstack1, playerIn.field_71071_by.field_70462_a.size(), bagslotcount, false) : !this.func_75135_a(itemstack1, 0, playerIn.field_71071_by.field_70462_a.size(), false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }
}

