/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.gui;

import com.flanks255.simplybackpacks.SimplyBackpacks;
import com.flanks255.simplybackpacks.inventory.FilterItemHandler;
import com.flanks255.simplybackpacks.items.BackpackItem;
import com.flanks255.simplybackpacks.network.FilterMessage;
import com.flanks255.simplybackpacks.network.ToggleMessage;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public class FilterContainer
extends Container {
    public final FilterItemHandler filterHandler;
    private int slotID;
    private final PlayerEntity playerEntity;
    private final ItemStack stack;

    public static FilterContainer fromNetwork(int windowId, PlayerInventory playerInventory, PacketBuffer extra) {
        CompoundNBT nbt = extra.func_244273_m();
        FilterItemHandler handler = new FilterItemHandler();
        handler.deserializeNBT(nbt);
        return new FilterContainer(windowId, playerInventory, handler);
    }

    public FilterContainer(int windowId, PlayerInventory playerInventory, FilterItemHandler handlerIn) {
        super((ContainerType)SimplyBackpacks.FILTERCONTAINER.get(), windowId);
        this.playerEntity = playerInventory.field_70458_d;
        this.stack = this.findBackpack(this.playerEntity);
        this.filterHandler = handlerIn;
        this.addPlayerSlots(playerInventory);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        if (this.slotID == -106) {
            return playerIn.func_184592_cb().func_77973_b() instanceof BackpackItem;
        }
        return playerIn.field_71071_by.func_70301_a(this.slotID).func_77973_b() instanceof BackpackItem;
    }

    private ItemStack findBackpack(PlayerEntity playerEntity) {
        PlayerInventory inv = playerEntity.field_71071_by;
        if (playerEntity.func_184614_ca().func_77973_b() instanceof BackpackItem) {
            for (int i = 0; i <= 8; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack != playerEntity.func_184614_ca()) continue;
                this.slotID = i;
                return stack;
            }
        } else {
            if (playerEntity.func_184592_cb().func_77973_b() instanceof BackpackItem) {
                this.slotID = -106;
                return playerEntity.func_184592_cb();
            }
            for (int i = 0; i <= 8; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof BackpackItem)) continue;
                this.slotID = i;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull PlayerEntity playerIn) {
        if (slotId >= 0 && this.func_75139_a(slotId).func_75211_c() == playerIn.func_184614_ca()) {
            return ItemStack.field_190927_a;
        }
        if (clickTypeIn == ClickType.SWAP) {
            return ItemStack.field_190927_a;
        }
        if (slotId >= 0) {
            this.func_75139_a((int)slotId).field_75224_c.func_70296_d();
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, playerIn);
    }

    public int getFilterOpts() {
        return this.stack.func_196082_o().func_74762_e("Filter-OPT");
    }

    public boolean getPickup() {
        return this.stack.func_196082_o().func_74767_n("Pickup");
    }

    public boolean togglePickup() {
        CompoundNBT nbt = this.stack.func_196082_o();
        boolean Pickup = !nbt.func_74767_n("Pickup");
        nbt.func_74757_a("Pickup", Pickup);
        if (this.playerEntity.func_130014_f_().field_72995_K) {
            SimplyBackpacks.NETWORK.sendToServer((Object)new ToggleMessage());
        }
        return Pickup;
    }

    public int setFilterOpts(int newOpts) {
        CompoundNBT nbt = this.stack.func_196082_o();
        nbt.func_74768_a("Filter-OPT", newOpts);
        this.stack.func_77982_d(nbt);
        if (this.playerEntity.func_130014_f_().field_72995_K) {
            SimplyBackpacks.NETWORK.sendToServer((Object)new FilterMessage(newOpts));
        }
        return newOpts;
    }

    public void saveFilter(int newOpts) {
        CompoundNBT nbt = this.stack.func_196082_o();
        nbt.func_74768_a("Filter-OPT", newOpts);
        this.stack.func_77982_d(nbt);
    }

    public void addPlayerSlots(PlayerInventory playerInventory) {
        int originX = 7;
        int originY = 83;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = originX + col * 18;
                int y = originY + row * 18;
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, x + 1, y + 1));
            }
        }
        for (int col = 0; col < 9; ++col) {
            int x = originX + col * 18;
            int y = originY + 58;
            this.func_75146_a(new Slot((IInventory)playerInventory, col, x + 1, y + 1));
        }
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        if (playerIn.field_71071_by.func_70445_o().func_190926_b()) {
            this.filterHandler.removeItem(id);
        } else {
            ItemStack fake = playerIn.field_71071_by.func_70445_o().func_77946_l();
            fake.func_190920_e(1);
            this.filterHandler.setItem(id, fake);
        }
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        for (int i = 0; i < this.filterHandler.getSlots(); ++i) {
            if (!this.filterHandler.getStackInSlot(i).func_190926_b()) continue;
            ItemStack fake = slot.func_75211_c().func_77946_l();
            fake.func_190920_e(1);
            this.filterHandler.setItem(i, fake);
            break;
        }
        return ItemStack.field_190927_a;
    }
}

