/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks.commands;

import com.flanks255.simplybackpacks.inventory.BackpackData;
import com.flanks255.simplybackpacks.inventory.BackpackManager;
import com.flanks255.simplybackpacks.util.BackpackUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemHandlerHelper;

public class Recover {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"recover").requires(cs -> cs.func_197034_c(1))).then(Commands.func_197056_a((String)"UUID", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> ISuggestionProvider.func_197005_b(BackpackUtils.getUUIDSuggestions((CommandContext<CommandSource>)context), (SuggestionsBuilder)builder)).executes(cs -> Recover.recover((CommandContext<CommandSource>)cs, StringArgumentType.getString((CommandContext)cs, (String)"UUID"))));
    }

    public static int recover(CommandContext<CommandSource> ctx, String stringUUID) throws CommandSyntaxException {
        UUID uuid;
        try {
            uuid = UUID.fromString(stringUUID);
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
        BackpackManager backpacks = BackpackManager.get();
        if (backpacks.getMap().containsKey(uuid)) {
            ServerPlayerEntity player = ((CommandSource)ctx.getSource()).func_197035_h();
            Optional<BackpackData> data = backpacks.getBackpack(uuid);
            data.ifPresent(backpack -> {
                ItemStack stack = new ItemStack((IItemProvider)backpack.getTier().item.get());
                stack.func_196082_o().func_186854_a("UUID", backpack.getUuid());
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
            });
        } else {
            ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("simplebackpacks.invaliduuid"));
        }
        return 0;
    }
}

