/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplybackpacks;

import com.flanks255.simplybackpacks.commands.SBCommands;
import com.flanks255.simplybackpacks.configuration.CommonConfiguration;
import com.flanks255.simplybackpacks.configuration.ConfigCache;
import com.flanks255.simplybackpacks.crafting.CopyBackpackDataRecipe;
import com.flanks255.simplybackpacks.crafting.TargetNBTIngredient;
import com.flanks255.simplybackpacks.data.Generator;
import com.flanks255.simplybackpacks.gui.FilterContainer;
import com.flanks255.simplybackpacks.gui.FilterGui;
import com.flanks255.simplybackpacks.gui.SBContainer;
import com.flanks255.simplybackpacks.gui.SBGui;
import com.flanks255.simplybackpacks.items.Backpack;
import com.flanks255.simplybackpacks.items.BackpackItem;
import com.flanks255.simplybackpacks.network.OpenMessage;
import com.flanks255.simplybackpacks.network.SBNetwork;
import com.flanks255.simplybackpacks.network.ToggleMessage;
import com.flanks255.simplybackpacks.util.BackpackUtils;
import com.flanks255.simplybackpacks.util.RecipeUnlocker;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.CommandSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeTagHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="simplybackpacks")
public class SimplyBackpacks {
    public static final String MODID = "simplybackpacks";
    public static final Logger LOGGER = LogManager.getLogger((String)"simplybackpacks");
    public static SimpleChannel NETWORK;
    public static final ITag.INamedTag<Item> HOLDS_ITEMS;
    public static final ITag.INamedTag<Item> CURIOS_BACK;
    public static final ITag.INamedTag<Enchantment> SOULBOUND;
    private static final DeferredRegister<Item> ITEMS;
    private static final DeferredRegister<ContainerType<?>> CONTAINERS;
    private static final DeferredRegister<IRecipeSerializer<?>> RECIPES;
    public static final RegistryObject<IRecipeSerializer<?>> COPYRECIPE;
    public static final RegistryObject<ContainerType<SBContainer>> SBCONTAINER;
    public static final RegistryObject<ContainerType<FilterContainer>> FILTERCONTAINER;
    public static final RegistryObject<Item> COMMONBACKPACK;
    public static final RegistryObject<Item> UNCOMMONBACKPACK;
    public static final RegistryObject<Item> RAREBACKPACK;
    public static final RegistryObject<Item> EPICBACKPACK;
    public static final RegistryObject<Item> ULTIMATEBACKPACK;
    private final NonNullList<KeyBinding> keyBinds = NonNullList.func_191196_a();

    public SimplyBackpacks() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        CONTAINERS.register(bus);
        RECIPES.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CommonConfiguration.COMMON_CONFIG);
        bus.addListener(this::onConfigReload);
        MinecraftForge.EVENT_BUS.addListener(this::onCommandsRegister);
        bus.addListener(this::setup);
        bus.addListener(this::clientStuff);
        bus.addListener(Generator::gatherData);
        bus.addListener(this::onEnqueueIMC);
        MinecraftForge.EVENT_BUS.addListener(this::pickupEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
        BackpackUtils.curiosLoaded = ModList.get().isLoaded("curios");
        RecipeUnlocker.register(MODID, MinecraftForge.EVENT_BUS, 1);
    }

    private void onEnqueueIMC(InterModEnqueueEvent event) {
        if (BackpackUtils.curiosLoaded) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
        }
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CraftingHelper.register((ResourceLocation)TargetNBTIngredient.Serializer.NAME, (IIngredientSerializer)TargetNBTIngredient.SERIALIZER));
        NETWORK = SBNetwork.register();
    }

    private void onCommandsRegister(RegisterCommandsEvent event) {
        SBCommands.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private void pickupEvent(EntityItemPickupEvent event) {
        ItemStack stack;
        if (event.getPlayer().field_71070_bA instanceof SBContainer || event.getPlayer().func_213453_ef() || event.getItem().func_92059_d().func_77973_b() instanceof BackpackItem) {
            return;
        }
        if (BackpackUtils.curiosLoaded && !(stack = CuriosApi.getCuriosHelper().findEquippedCurio(BackpackItem::isBackpack, event.getEntityLiving()).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a)).func_190926_b() && BackpackItem.pickupEvent(event, stack)) {
            event.setResult(Event.Result.ALLOW);
            return;
        }
        PlayerInventory playerInv = event.getPlayer().field_71071_by;
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack2 = playerInv.func_70301_a(i);
            if (!(stack2.func_77973_b() instanceof BackpackItem) || !BackpackItem.pickupEvent(event, stack2)) continue;
            event.setResult(Event.Result.ALLOW);
            return;
        }
    }

    private void onClientTick(TickEvent.ClientTickEvent event) {
        if (((KeyBinding)this.keyBinds.get(0)).func_151468_f()) {
            NETWORK.sendToServer((Object)new ToggleMessage());
        }
        if (((KeyBinding)this.keyBinds.get(1)).func_151468_f()) {
            NETWORK.sendToServer((Object)new OpenMessage());
        }
    }

    private void clientStuff(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)SBCONTAINER.get()), SBGui::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)FILTERCONTAINER.get()), FilterGui::new);
        this.keyBinds.add(0, (Object)new KeyBinding("key.simplybackpacks.backpackpickup.desc", -1, "key.simplybackpacks.category"));
        this.keyBinds.add(1, (Object)new KeyBinding("key.simplybackpacks.backpackopen.desc", -1, "key.simplybackpacks.category"));
        ClientRegistry.registerKeyBinding((KeyBinding)((KeyBinding)this.keyBinds.get(0)));
        ClientRegistry.registerKeyBinding((KeyBinding)((KeyBinding)this.keyBinds.get(1)));
    }

    private void onConfigReload(ModConfig.ModConfigEvent event) {
        ConfigCache.RefreshCache();
    }

    static {
        HOLDS_ITEMS = ItemTags.func_199901_a((String)new ResourceLocation("forge", "holds_items").toString());
        CURIOS_BACK = ItemTags.func_199901_a((String)new ResourceLocation("curios", "back").toString());
        SOULBOUND = ForgeTagHandler.makeWrapperTag((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (ResourceLocation)new ResourceLocation("forge", "soulbound"));
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
        CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)MODID);
        RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)MODID);
        COPYRECIPE = RECIPES.register("backpack_upgrade", CopyBackpackDataRecipe.Serializer::new);
        SBCONTAINER = CONTAINERS.register("sb_container", () -> IForgeContainerType.create(SBContainer::fromNetwork));
        FILTERCONTAINER = CONTAINERS.register("filter_container", () -> IForgeContainerType.create(FilterContainer::fromNetwork));
        COMMONBACKPACK = ITEMS.register("commonbackpack", () -> new BackpackItem("commonbackpack", Backpack.COMMON));
        UNCOMMONBACKPACK = ITEMS.register("uncommonbackpack", () -> new BackpackItem("uncommonbackpack", Backpack.UNCOMMON));
        RAREBACKPACK = ITEMS.register("rarebackpack", () -> new BackpackItem("rarebackpack", Backpack.RARE));
        EPICBACKPACK = ITEMS.register("epicbackpack", () -> new BackpackItem("epicbackpack", Backpack.EPIC));
        ULTIMATEBACKPACK = ITEMS.register("ultimatebackpack", () -> new BackpackItem("ultimatebackpack", Backpack.ULTIMATE));
    }
}

