/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplyutilities.tile;

import com.flanks255.simplyutilities.SUBlocks;
import com.flanks255.simplyutilities.blocks.OnlineDetector;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Util;

public class TEOnlineDetector
extends TileEntity
implements ITickableTileEntity {
    private UUID uuid = Util.field_240973_b_;
    private String playerName = "";
    private final int tickOffset;
    private final int interval = 20;
    public boolean onlineState;
    public int baseEyeAngle = 0;
    public float currentEyeOffset;
    public float prevEyeOffset;
    public float eyeOffsetTarget = 0.0f;
    public long targetTicks;
    public float ringAngle;
    public float prevRingAngle = 0.0f;
    private final Random rand = new Random();

    public TEOnlineDetector() {
        super(SUBlocks.ONLINE_DETECTOR.getTileEntityType());
        this.tickOffset = this.rand.nextInt(20);
        this.rand.setSeed(this.tickOffset);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_186854_a("PlacerUUID", this.uuid);
        nbt.func_74778_a("PlacerName", this.playerName);
        nbt.func_74757_a("OnlineState", this.onlineState);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        super.handleUpdateTag(state, nbt);
        this.uuid = nbt.func_186857_a("PlacerUUID");
        this.playerName = nbt.func_74779_i("PlacerName");
        this.onlineState = nbt.func_74767_n("OnlineState");
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("OnlineState", this.onlineState);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        this.onlineState = nbt.func_74767_n("OnlineState");
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.uuid = nbt.func_186857_a("PlacerUUID");
        this.playerName = nbt.func_74779_i("PlacerName");
        this.onlineState = nbt.func_74767_n("OnlineState");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_186854_a("PlacerUUID", this.uuid);
        nbt.func_74778_a("PlacerName", this.playerName);
        nbt.func_74757_a("OnlineState", this.onlineState);
        return super.func_189515_b(nbt);
    }

    public int wrapDegrees(int in) {
        if (in > 360) {
            in -= 360;
        } else if (in < 0) {
            in += 360;
        }
        return in;
    }

    public void func_73660_a() {
        BlockState state;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.prevRingAngle = this.ringAngle;
            if (this.ringAngle < 360.0f) {
                this.ringAngle = (float)((double)this.ringAngle + 4.5);
            }
            if (this.ringAngle >= 360.0f) {
                this.ringAngle -= 360.0f;
                this.prevRingAngle -= 360.0f;
            }
            if (this.targetTicks - this.field_145850_b.func_82737_E() >= 0L) {
                this.prevEyeOffset = this.currentEyeOffset;
                this.currentEyeOffset = this.eyeOffsetTarget * (1.0f - (float)(this.targetTicks - this.field_145850_b.func_82737_E()) / 20.0f);
            } else {
                this.prevEyeOffset = this.currentEyeOffset;
            }
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K && (this.field_145850_b.func_82737_E() + (long)this.tickOffset) % 80L == 0L) {
            this.baseEyeAngle = (int)((float)this.baseEyeAngle + this.eyeOffsetTarget);
            this.baseEyeAngle = this.wrapDegrees(this.baseEyeAngle);
            this.prevEyeOffset = 0.0f;
            this.currentEyeOffset = 0.0f;
            this.eyeOffsetTarget = this.rand.nextInt(270) - 135;
            this.targetTicks = this.field_145850_b.func_82737_E() + 20L;
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && (this.field_145850_b.func_82737_E() + (long)this.tickOffset) % 20L == 0L && (state = this.func_195044_w()).func_177230_c() instanceof OnlineDetector) {
            boolean newStatus;
            boolean oldStatus = (Boolean)state.func_177229_b((Property)OnlineDetector.ON);
            this.onlineState = newStatus = this.isOnline(this.uuid);
            if (oldStatus != newStatus) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)OnlineDetector.ON, (Comparable)Boolean.valueOf(newStatus)), 7);
            }
        }
    }

    public boolean isOnline(UUID uuidIn) {
        if (this.field_145850_b != null && this.field_145850_b.func_73046_m() != null) {
            return this.field_145850_b.func_73046_m().func_184103_al().func_177451_a(uuidIn) != null;
        }
        return false;
    }

    public void setPlayer(PlayerEntity player) {
        this.uuid = player.func_110124_au();
        this.playerName = player.func_200200_C_().getString();
    }

    public UUID getPlayerUUID() {
        return this.uuid;
    }

    public String getPlayerName() {
        return this.playerName;
    }
}

