/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplyutilities.network;

import com.flanks255.simplyutilities.configuration.ClientConfiguration;
import com.flanks255.simplyutilities.configuration.ConfigCache;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class ZoomSmoothMessage {
    private final boolean smoothcam;

    public ZoomSmoothMessage(boolean setSmoothcam) {
        this.smoothcam = setSmoothcam;
    }

    public boolean isSmoothcam() {
        return this.smoothcam;
    }

    public static ZoomSmoothMessage decode(PacketBuffer buffer) {
        return new ZoomSmoothMessage(buffer.readBoolean());
    }

    public static void encode(ZoomSmoothMessage message, PacketBuffer buffer) {
        buffer.writeBoolean(message.isSmoothcam());
    }

    public static void handle(ZoomSmoothMessage message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> {
                ClientConfiguration.ZOOMSMOOTHCAM.set((Object)message.isSmoothcam());
                ClientConfiguration.CLIENT_CONFIG.save();
                ConfigCache.RefreshCache();
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

