/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplyutilities.network;

import com.flanks255.simplyutilities.configuration.ClientConfiguration;
import com.flanks255.simplyutilities.configuration.ConfigCache;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class ZoomFOVMessage {
    private final double fov;

    public ZoomFOVMessage(double zoomfov) {
        this.fov = zoomfov;
    }

    public double getFov() {
        return this.fov;
    }

    public static ZoomFOVMessage decode(PacketBuffer buffer) {
        return new ZoomFOVMessage(buffer.readDouble());
    }

    public static void encode(ZoomFOVMessage message, PacketBuffer buffer) {
        buffer.writeDouble(message.getFov());
    }

    public static void handle(ZoomFOVMessage message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> {
                ClientConfiguration.ZOOMFOV.set((Object)message.getFov());
                ClientConfiguration.CLIENT_CONFIG.save();
                ConfigCache.RefreshCache();
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

