/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplyutilities.commands.debug;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DebugScreen
extends Screen {
    ItemStack stack;
    viewTab currentTab = viewTab.BASIC;
    private ResourceLocation GUI = new ResourceLocation("simplyutilities", "textures/gui/debughand.png");
    private int guiLeft;
    private int guiTop;
    private int xSize = 256;
    private int ySize = 220;

    public DebugScreen(ItemStack serverStack) {
        super((ITextComponent)new StringTextComponent("SU Debug Screen"));
        this.stack = serverStack;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        Button.IPressable tabClick = new Button.IPressable(){

            public void onPress(Button p_onPress_1_) {
                ((ViewButton)p_onPress_1_).clickTab();
            }
        };
        this.func_230480_a_((Widget)new ViewButton(this, this.guiLeft + 20, this.guiTop + 3, 56, 10, (ITextComponent)new StringTextComponent("Basic"), viewTab.BASIC, tabClick));
        this.func_230480_a_((Widget)new ViewButton(this, this.guiLeft + 76, this.guiTop + 3, 56, 10, (ITextComponent)new StringTextComponent("Tags"), viewTab.TAGS, tabClick));
        this.func_230480_a_((Widget)new ViewButton(this, this.guiLeft + 132, this.guiTop + 3, 56, 10, (ITextComponent)new StringTextComponent("NBT Data"), viewTab.NBT, tabClick));
        this.func_230480_a_((Widget)new ViewButton(this, this.guiLeft + 188, this.guiTop + 3, 56, 10, (ITextComponent)new StringTextComponent("Class info"), viewTab.CLASSES, tabClick));
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public void func_230446_a_(MatrixStack matrixStack) {
        super.func_230446_a_(matrixStack);
        this.getMinecraft().field_71446_o.func_110577_a(this.GUI);
        DebugScreen.func_238463_a_((MatrixStack)matrixStack, (int)this.guiLeft, (int)this.guiTop, (float)0.0f, (float)0.0f, (int)256, (int)220, (int)256, (int)256);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.field_230705_e_.forEach(child -> {
            if (child instanceof Widget) {
                ((Widget)child).func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            }
        });
        switch (this.currentTab) {
            case BASIC: {
                DebugScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)("Display Name: " + this.stack.func_200301_q().getString()), (int)(this.guiLeft + 8), (int)(this.guiTop + 24), (int)0xFFFFFF);
                DebugScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)("Registry Name: " + this.stack.func_77973_b().getRegistryName()), (int)(this.guiLeft + 8), (int)(this.guiTop + 34), (int)0xFFFFFF);
                break;
            }
            case TAGS: {
                DebugScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)("Tags: " + this.stack.func_77973_b().getTags()), (int)(this.guiLeft + 8), (int)(this.guiTop + 24), (int)0xFFFFFF);
                break;
            }
            case NBT: {
                if (this.stack.func_77942_o()) {
                    String[] lineList = this.stack.func_77978_p().func_199850_a(" ", 1).getString().split("\n");
                    int y = this.guiTop + 24;
                    for (String line : lineList) {
                        DebugScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent(line), (int)(this.guiLeft + 8), (int)y, (int)0xFFFFFF);
                        y += 10;
                    }
                    break;
                }
                DebugScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"NBT: None", (int)(this.guiLeft + 8), (int)(this.guiTop + 24), (int)0xFFFFFF);
                break;
            }
        }
        matrixStack.func_227860_a_();
        RenderSystem.enableDepthTest();
        RenderHelper.func_227780_a_();
        this.field_230707_j_.func_180450_b(this.stack, this.guiLeft + 3, this.guiTop + 3);
        RenderHelper.func_74518_a();
        matrixStack.func_227865_b_();
    }

    class ViewButton
    extends Button {
        viewTab myTab;
        DebugScreen parent;

        public ViewButton(DebugScreen parentIn, int x, int y, int width, int height, ITextComponent title, viewTab tab, Button.IPressable action) {
            super(x, y, width, height, title, action);
            this.parent = parentIn;
            this.myTab = tab;
        }

        public void clickTab() {
            DebugScreen.this.currentTab = this.myTab;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            DebugScreen.this.getMinecraft().field_71446_o.func_110577_a(DebugScreen.this.GUI);
            if (this.parent.currentTab == this.myTab) {
                ViewButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)232.0f, (int)56, (int)12, (int)256, (int)256);
            } else {
                ViewButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)220.0f, (int)56, (int)12, (int)256, (int)256);
            }
            ViewButton.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)DebugScreen.this.field_230712_o_, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + this.field_230688_j_ / 2), (int)(this.field_230691_m_ + (this.field_230689_k_ - 6) / 2), (int)0xFFFFFF);
        }
    }

    static enum viewTab {
        BASIC,
        TAGS,
        NBT,
        CLASSES;

    }
}

