/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplyutilities;

import com.flanks255.simplyutilities.SUBlocks;
import com.flanks255.simplyutilities.SUItems;
import com.flanks255.simplyutilities.blocks.EnderInhibitor;
import com.flanks255.simplyutilities.commands.MyCommands;
import com.flanks255.simplyutilities.configuration.ClientConfiguration;
import com.flanks255.simplyutilities.configuration.CommonConfiguration;
import com.flanks255.simplyutilities.configuration.ConfigCache;
import com.flanks255.simplyutilities.configuration.ServerConfiguration;
import com.flanks255.simplyutilities.data.BoolConfigCondition;
import com.flanks255.simplyutilities.data.Generator;
import com.flanks255.simplyutilities.items.ExoLeggings;
import com.flanks255.simplyutilities.network.ClientNetProxy;
import com.flanks255.simplyutilities.network.CommonNetProxy;
import com.flanks255.simplyutilities.network.SUNetwork;
import com.flanks255.simplyutilities.render.OnlineDetectorRender;
import com.flanks255.simplyutilities.tweaks.DoubleDoorFix;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.CommandSource;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="simplyutilities")
public class SimplyUtilities {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "simplyutilities";
    public static SimpleChannel NETWORK;
    public static CommonNetProxy NETPROXY;
    public static boolean isQuarkLoaded;
    private final NonNullList<KeyBinding> keyBinds = NonNullList.func_191196_a();

    public SimplyUtilities() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        SUBlocks.init(modBus);
        SUItems.init(modBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ServerConfiguration.SERVER_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CommonConfiguration.COMMON_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ClientConfiguration.CLIENT_CONFIG);
        modBus.addListener(this::onConfigReload);
        MinecraftForge.EVENT_BUS.addListener(this::onCommandsRegister);
        modBus.addListener(Generator::gatherData);
        modBus.addListener(this::setup);
        modBus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.addListener(EnderInhibitor::TeleportEvent);
        MinecraftForge.EVENT_BUS.addListener(ExoLeggings::onEntityHurt);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, DoubleDoorFix::playerInteraction);
        NETPROXY = (CommonNetProxy)DistExecutor.safeRunForDist(() -> ClientNetProxy::new, () -> CommonNetProxy::new);
    }

    private void setup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> CraftingHelper.register((IConditionSerializer)BoolConfigCondition.Serializer.INSTANCE));
        NETWORK = SUNetwork.getNetworkChannel();
        isQuarkLoaded = ModList.get().isLoaded("quark");
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(this::onRenderViewEvent);
        ClientRegistry.bindTileEntityRenderer(SUBlocks.ONLINE_DETECTOR.getTileEntityType(), OnlineDetectorRender::new);
        this.keyBinds.add(0, (Object)new KeyBinding("key.simplyutilities.zoom.desc", -1, "key.simplyutilities.category"));
        ClientRegistry.registerKeyBinding((KeyBinding)((KeyBinding)this.keyBinds.get(0)));
    }

    private void onCommandsRegister(RegisterCommandsEvent event) {
        MyCommands.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private void onConfigReload(ModConfig.ModConfigEvent event) {
        ConfigCache.RefreshCache();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onRenderViewEvent(EntityViewRenderEvent.FOVModifier event) {
        if (((KeyBinding)this.keyBinds.get(0)).func_151470_d()) {
            event.setFOV(ConfigCache.zoom_fov);
            if (ConfigCache.zoom_smooth) {
                Minecraft.func_71410_x().field_71474_y.field_74326_T = true;
            }
        } else if (ConfigCache.zoom_smooth) {
            Minecraft.func_71410_x().field_71474_y.field_74326_T = false;
        }
    }

    static {
        isQuarkLoaded = false;
    }
}

