/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.tileentity.loader;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import xyz.brassgoggledcoders.transport.capability.FluidHandlerDirectional;
import xyz.brassgoggledcoders.transport.tileentity.loader.BasicLoaderTileEntity;

public class FluidLoaderTileEntity
extends BasicLoaderTileEntity<IFluidHandler> {
    private final FluidTankComponent<FluidLoaderTileEntity> fluidTankComponent = new FluidTankComponent("Loader", 10000, 80, 28);
    private final LazyOptional<IFluidHandler> lazyFluid = LazyOptional.of(() -> this.fluidTankComponent);

    public FluidLoaderTileEntity(TileEntityType<? extends FluidLoaderTileEntity> tileEntityType) {
        super(tileEntityType, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    @Override
    protected void transfer(IFluidHandler from, IFluidHandler to) {
        int filledAmount;
        FluidStack output = from.drain(5000, IFluidHandler.FluidAction.SIMULATE);
        if (!output.isEmpty() && (filledAmount = to.fill(output, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            to.fill(from.drain(filledAmount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void onActivated(PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (this.getTheWorld().field_72995_K || !FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, this.fluidTankComponent)) {
            super.onActivated(player, hand, rayTraceResult);
        }
    }

    @Override
    protected LazyOptional<IFluidHandler> getInternalCAP() {
        return this.lazyFluid;
    }

    @Override
    protected LazyOptional<IFluidHandler> createOutputCAP() {
        return LazyOptional.of(() -> new FluidHandlerDirectional((IFluidHandler)this.fluidTankComponent, false));
    }

    @Override
    protected LazyOptional<IFluidHandler> createInputCAP() {
        return LazyOptional.of(() -> new FluidHandlerDirectional((IFluidHandler)this.fluidTankComponent, true));
    }

    @Override
    protected CompoundNBT serializeCap() {
        return this.fluidTankComponent.writeToNBT(new CompoundNBT());
    }

    @Override
    protected void deserializeCap(CompoundNBT compoundNBT) {
        this.fluidTankComponent.readFromNBT(compoundNBT);
    }

    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return this.fluidTankComponent.getScreenAddons();
    }

    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return this.fluidTankComponent.getContainerAddons();
    }
}

