/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.screen.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;
import xyz.brassgoggledcoders.transport.content.TransportText;
import xyz.brassgoggledcoders.transport.screen.util.FluidRenderer;
import xyz.brassgoggledcoders.transport.screen.widget.IHoverableWidget;

public class FluidTankWidget
extends Widget
implements IHoverableWidget {
    private static final ResourceLocation COMPONENTS = new ResourceLocation("titanium", "textures/gui/background.png");
    private final NonNullSupplier<FluidStack> fluidStack;
    private final IntSupplier tankSize;

    public FluidTankWidget(int x, int y, NonNullSupplier<FluidStack> fluidStack, IntSupplier tankSize) {
        super(x, y, 18, 56, (ITextComponent)new StringTextComponent("Fluid Tank"));
        this.fluidStack = fluidStack;
        this.tankSize = tankSize;
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.field_230694_p_) {
            FluidStack renderStack = (FluidStack)this.fluidStack.get();
            FluidRenderer.renderFluid(matrixStack, renderStack, this.tankSize.getAsInt(), this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(COMPONENTS);
            this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, 177, 1, this.field_230688_j_, this.field_230689_k_);
        }
    }

    public void func_230431_b_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    @Nonnull
    public List<? extends ITextProperties> getHoveredText() {
        FluidStack fluidStack = (FluidStack)this.fluidStack.get();
        if (fluidStack.isEmpty()) {
            return Collections.singletonList(TransportText.SCREEN_FLUID_EMPTY);
        }
        return Lists.newArrayList((Object[])new ITextComponent[]{TransportText.FLUID.withArgs(fluidStack.getDisplayName().func_230532_e_().func_240699_a_(TextFormatting.WHITE)), TransportText.AMOUNT.withArgs(new StringTextComponent("" + fluidStack.getAmount()).func_240699_a_(TextFormatting.WHITE), new StringTextComponent("" + this.tankSize.getAsInt()).func_240699_a_(TextFormatting.WHITE), TransportText.MILLI_BUCKET)});
    }
}

