/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.repack.registrate.builders;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.RegistryObject;
import xyz.brassgoggledcoders.transport.repack.registrate.AbstractRegistrate;
import xyz.brassgoggledcoders.transport.repack.registrate.builders.AbstractBuilder;
import xyz.brassgoggledcoders.transport.repack.registrate.builders.BlockBuilder;
import xyz.brassgoggledcoders.transport.repack.registrate.builders.BuilderCallback;
import xyz.brassgoggledcoders.transport.repack.registrate.builders.ItemBuilder;
import xyz.brassgoggledcoders.transport.repack.registrate.providers.ProviderType;
import xyz.brassgoggledcoders.transport.repack.registrate.providers.RegistrateLangProvider;
import xyz.brassgoggledcoders.transport.repack.registrate.util.NonNullLazyValue;
import xyz.brassgoggledcoders.transport.repack.registrate.util.entry.FluidEntry;
import xyz.brassgoggledcoders.transport.repack.registrate.util.entry.RegistryEntry;
import xyz.brassgoggledcoders.transport.repack.registrate.util.nullness.NonNullBiConsumer;
import xyz.brassgoggledcoders.transport.repack.registrate.util.nullness.NonNullBiFunction;
import xyz.brassgoggledcoders.transport.repack.registrate.util.nullness.NonNullConsumer;
import xyz.brassgoggledcoders.transport.repack.registrate.util.nullness.NonNullFunction;
import xyz.brassgoggledcoders.transport.repack.registrate.util.nullness.NonNullSupplier;

public class FluidBuilder<T extends ForgeFlowingFluid, P>
extends AbstractBuilder<Fluid, T, P, FluidBuilder<T, P>> {
    private final ResourceLocation stillTexture;
    private final String sourceName;
    private final String bucketName;
    private final NonNullSupplier<FluidAttributes.Builder> attributes;
    private final NonNullFunction<ForgeFlowingFluid.Properties, T> factory;
    @Nullable
    private Boolean defaultSource;
    @Nullable
    private Boolean defaultBlock;
    @Nullable
    private Boolean defaultBucket;
    private NonNullConsumer<FluidAttributes.Builder> attributesCallback = $ -> {};
    private NonNullConsumer<ForgeFlowingFluid.Properties> properties;
    @Nullable
    private NonNullLazyValue<? extends ForgeFlowingFluid> source;
    private List<ITag.INamedTag<Fluid>> tags = new ArrayList<ITag.INamedTag<Fluid>>();

    public static <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, (NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes>)null);
    }

    public static <P> FluidBuilder<ForgeFlowingFluid.Flowing, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, attributesFactory, ForgeFlowingFluid.Flowing::new);
    }

    public static <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, null, factory);
    }

    public static <T extends ForgeFlowingFluid, P> FluidBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable NonNullBiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        FluidBuilder<T, P> ret = new FluidBuilder<T, P>(owner, parent, name, callback, stillTexture, flowingTexture, attributesFactory, factory).defaultLang().defaultSource().defaultBlock().defaultBucket().tag(FluidTags.field_206959_a);
        return ret;
    }

    protected FluidBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, @Nullable BiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory, NonNullFunction<ForgeFlowingFluid.Properties, T> factory) {
        super(owner, parent, "flowing_" + name, callback, Fluid.class);
        this.stillTexture = stillTexture;
        this.sourceName = name;
        this.bucketName = name + "_bucket";
        this.attributes = () -> attributesFactory == null ? FluidAttributes.builder((ResourceLocation)stillTexture, (ResourceLocation)flowingTexture) : new Builder(stillTexture, flowingTexture, attributesFactory);
        this.factory = factory;
        String bucketName = this.bucketName;
        this.properties = p -> p.bucket(() -> (Item)owner.get(bucketName, Item.class).get()).block(() -> (FlowingFluidBlock)owner.get(name, Block.class).get());
    }

    public FluidBuilder<T, P> attributes(NonNullConsumer<FluidAttributes.Builder> cons) {
        this.attributesCallback = this.attributesCallback.andThen(cons);
        return this;
    }

    public FluidBuilder<T, P> properties(NonNullConsumer<ForgeFlowingFluid.Properties> cons) {
        this.properties = this.properties.andThen(cons);
        return this;
    }

    public FluidBuilder<T, P> defaultLang() {
        return (FluidBuilder)this.lang(f -> f.getAttributes().getTranslationKey(), RegistrateLangProvider.toEnglishName(this.sourceName));
    }

    public FluidBuilder<T, P> lang(String name) {
        return (FluidBuilder)this.lang(f -> f.getAttributes().getTranslationKey(), name);
    }

    public FluidBuilder<T, P> defaultSource() {
        if (this.defaultSource != null) {
            throw new IllegalStateException("Cannot set a default source after a custom source has been created");
        }
        this.defaultSource = true;
        return this;
    }

    public FluidBuilder<T, P> source(NonNullFunction<ForgeFlowingFluid.Properties, ? extends ForgeFlowingFluid> factory) {
        this.defaultSource = false;
        this.source = new NonNullLazyValue<ForgeFlowingFluid>(() -> (ForgeFlowingFluid)factory.apply(this.makeProperties()));
        return this;
    }

    public FluidBuilder<T, P> defaultBlock() {
        if (this.defaultBlock != null) {
            throw new IllegalStateException("Cannot set a default block after a custom block has been created");
        }
        this.defaultBlock = true;
        return this;
    }

    public BlockBuilder<FlowingFluidBlock, FluidBuilder<T, P>> block() {
        return this.block(FlowingFluidBlock::new);
    }

    public <B extends FlowingFluidBlock> BlockBuilder<B, FluidBuilder<T, P>> block(NonNullBiFunction<NonNullSupplier<? extends T>, AbstractBlock.Properties, ? extends B> factory) {
        if (this.defaultBlock == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to block/noBlock per builder allowed");
        }
        this.defaultBlock = false;
        NonNullSupplier supplier = this.asSupplier();
        return this.getOwner().block(this, this.sourceName, p -> (FlowingFluidBlock)factory.apply(supplier, (AbstractBlock.Properties)p)).properties(p -> AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150355_j).func_222380_e()).properties(p -> {
            FluidAttributes attrs = this.attributes.get().build((Fluid)Fluids.field_204546_a);
            return p.func_235838_a_($ -> attrs.getLuminosity());
        }).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(this.sourceName)).texture("particle", this.stillTexture)));
    }

    @Beta
    public FluidBuilder<T, P> noBlock() {
        if (this.defaultBlock == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to block/noBlock per builder allowed");
        }
        this.defaultBlock = false;
        return this;
    }

    public FluidBuilder<T, P> defaultBucket() {
        if (this.defaultBucket != null) {
            throw new IllegalStateException("Cannot set a default bucket after a custom bucket has been created");
        }
        this.defaultBucket = true;
        return this;
    }

    public ItemBuilder<BucketItem, FluidBuilder<T, P>> bucket() {
        return this.bucket(BucketItem::new);
    }

    public <I extends BucketItem> ItemBuilder<I, FluidBuilder<T, P>> bucket(NonNullBiFunction<Supplier<? extends ForgeFlowingFluid>, Item.Properties, ? extends I> factory) {
        if (this.defaultBucket == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to bucket/noBucket per builder allowed");
        }
        this.defaultBucket = false;
        return this.getOwner().item(this, this.bucketName, p -> (BucketItem)factory.apply((Supplier<? extends ForgeFlowingFluid>)this.source, (Item.Properties)p)).properties(p -> p.func_200919_a(Items.field_151133_ar).func_200917_a(1)).model((ctx, prov) -> prov.generated(ctx::getEntry, new ResourceLocation(this.getOwner().getModid(), "item/" + this.bucketName)));
    }

    @Beta
    public FluidBuilder<T, P> noBucket() {
        if (this.defaultBucket == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to bucket/noBucket per builder allowed");
        }
        this.defaultBucket = false;
        return this;
    }

    @SafeVarargs
    public final FluidBuilder<T, P> tag(ITag.INamedTag<Fluid> ... tags) {
        FluidBuilder ret = (FluidBuilder)this.tag(ProviderType.FLUID_TAGS, tags);
        if (this.tags.isEmpty()) {
            ret.getOwner().setDataGenerator(ret.sourceName, this.getRegistryType(), ProviderType.FLUID_TAGS, prov -> this.tags.stream().map(prov::func_240522_a_).forEach(p -> p.func_240534_a_((Object[])new Fluid[]{this.getSource()})));
        }
        this.tags.addAll(Arrays.asList(tags));
        return ret;
    }

    @SafeVarargs
    public final FluidBuilder<T, P> removeTag(ITag.INamedTag<Fluid> ... tags) {
        this.tags.removeAll(Arrays.asList(tags));
        return (FluidBuilder)this.removeTag(ProviderType.FLUID_TAGS, tags);
    }

    private ForgeFlowingFluid getSource() {
        NonNullLazyValue<? extends ForgeFlowingFluid> source = this.source;
        Preconditions.checkNotNull(source, (Object)("Fluid has no source block: " + this.sourceName));
        return source.get();
    }

    private ForgeFlowingFluid.Properties makeProperties() {
        FluidAttributes.Builder attributes = this.attributes.get();
        RegistryEntry block = this.getOwner().getOptional(this.sourceName, Block.class);
        this.attributesCallback.accept(attributes);
        if (block.isPresent()) {
            attributes.translationKey(((Block)block.get()).func_149739_a());
            this.setData(ProviderType.LANG, NonNullBiConsumer.noop());
        } else {
            attributes.translationKey(Util.func_200697_a((String)"fluid", (ResourceLocation)new ResourceLocation(this.getOwner().getModid(), this.sourceName)));
        }
        ForgeFlowingFluid.Properties ret = new ForgeFlowingFluid.Properties(this.source, this.asSupplier(), attributes);
        this.properties.accept(ret);
        return ret;
    }

    @Override
    protected T createEntry() {
        return (T)((ForgeFlowingFluid)this.factory.apply(this.makeProperties()));
    }

    @Override
    public FluidEntry<T> register() {
        NonNullLazyValue<? extends ForgeFlowingFluid> source;
        if (this.defaultSource == Boolean.TRUE) {
            this.source(ForgeFlowingFluid.Source::new);
        }
        if (this.defaultBlock == Boolean.TRUE) {
            this.block().register();
        }
        if (this.defaultBucket == Boolean.TRUE) {
            this.bucket().register();
        }
        if ((source = this.source) == null) {
            throw new IllegalStateException("Fluid must have a source version: " + this.getName());
        }
        this.getCallback().accept(this.sourceName, Fluid.class, this, source);
        return (FluidEntry)super.register();
    }

    @Override
    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new FluidEntry<T>(this.getOwner(), delegate);
    }

    private static class Builder
    extends FluidAttributes.Builder {
        protected Builder(ResourceLocation still, ResourceLocation flowing, BiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> attributesFactory) {
            super(still, flowing, attributesFactory);
        }
    }
}

