/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.renderer.minecart;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import xyz.brassgoggledcoders.transport.entity.locomotive.LocomotiveEntity;
import xyz.brassgoggledcoders.transport.model.item.EntityItemModelCache;
import xyz.brassgoggledcoders.transport.util.CachedValue;

public class LocomotiveRenderer<T extends LocomotiveEntity<?>>
extends MinecartRenderer<T> {
    private final float scale;
    private final float translateDown;
    private CachedValue<IBakedModel> cachedBakedModel;

    public LocomotiveRenderer(EntityRendererManager renderManager) {
        super(renderManager);
        this.scale = 1.0f;
        this.translateDown = 0.4f;
    }

    @ParametersAreNonnullByDefault
    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        matrixStack.func_227860_a_();
        long i = (long)entity.func_145782_y() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        matrixStack.func_227861_a_((double)f, (double)f1, (double)f2);
        double d0 = MathHelper.func_219803_d((double)partialTicks, (double)((LocomotiveEntity)entity).field_70142_S, (double)entity.func_226277_ct_());
        double d1 = MathHelper.func_219803_d((double)partialTicks, (double)((LocomotiveEntity)entity).field_70137_T, (double)entity.func_226278_cu_());
        double d2 = MathHelper.func_219803_d((double)partialTicks, (double)((LocomotiveEntity)entity).field_70136_U, (double)entity.func_226281_cx_());
        Vector3d vec3d = entity.func_70489_a(d0, d1, d2);
        float pitch = MathHelper.func_219799_g((float)partialTicks, (float)((LocomotiveEntity)entity).field_70127_C, (float)((LocomotiveEntity)entity).field_70125_A);
        if (vec3d != null) {
            Vector3d vec3d1 = entity.func_70495_a(d0, d1, d2, (double)0.3f);
            Vector3d vec3d2 = entity.func_70495_a(d0, d1, d2, (double)-0.3f);
            if (vec3d1 == null) {
                vec3d1 = vec3d;
            }
            if (vec3d2 == null) {
                vec3d2 = vec3d;
            }
            matrixStack.func_227861_a_(vec3d.field_72450_a - d0, (vec3d1.field_72448_b + vec3d2.field_72448_b) / 2.0 - d1, vec3d.field_72449_c - d2);
            Vector3d vec3d3 = vec3d2.func_72441_c(-vec3d1.field_72450_a, -vec3d1.field_72448_b, -vec3d1.field_72449_c);
            if (vec3d3.func_72433_c() != 0.0) {
                vec3d3 = vec3d3.func_72432_b();
                entityYaw = (float)(Math.atan2(vec3d3.field_72449_c, vec3d3.field_72450_a) / Math.PI) * 180.0f;
                pitch = (float)(Math.atan(vec3d3.field_72448_b) * 73.0);
            }
        }
        if ((entityYaw %= 360.0f) < 0.0f) {
            entityYaw += 360.0f;
        }
        entityYaw += 360.0f;
        double rotationYaw = (((LocomotiveEntity)entity).field_70177_z + 180.0f) % 360.0f;
        if (rotationYaw < 0.0) {
            rotationYaw += 360.0;
        }
        if (Math.abs((double)entityYaw - (rotationYaw += 360.0)) > 90.0) {
            entityYaw += 180.0f;
            pitch = -pitch;
        }
        ((LocomotiveEntity)entity).setClientAngle(entityYaw);
        matrixStack.func_227861_a_(0.0, 0.375, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityYaw));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-pitch));
        float f5 = (float)entity.func_70496_j() - partialTicks;
        float f6 = entity.func_70491_i() - partialTicks;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f5 > 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_76126_a((float)f5) * f5 * f6 / 10.0f * (float)entity.func_70493_k()));
        }
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        IBakedModel model = this.getCachedBakedModel(entity).getValue();
        if (model != null) {
            matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            matrixStack.func_227861_a_(0.0, (double)(-this.translateDown), 0.0);
            Minecraft.func_71410_x().func_175599_af().func_229114_a_(model, ItemStack.field_190927_a, packedLight, OverlayTexture.field_229196_a_, matrixStack, buffer.getBuffer(RenderType.func_228645_f_()));
        }
        matrixStack.func_227865_b_();
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull T entity) {
        return ((LocomotiveEntity)entity).getTextureLocation();
    }

    public CachedValue<IBakedModel> getCachedBakedModel(@Nonnull T entity) {
        if (this.cachedBakedModel == null) {
            this.cachedBakedModel = EntityItemModelCache.getBakedModelCacheFor(((LocomotiveEntity)entity).getRenderItemStack().func_77973_b());
        }
        return this.cachedBakedModel;
    }
}

