/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.renderer.boat;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import xyz.brassgoggledcoders.transport.entity.TugBoatEntity;
import xyz.brassgoggledcoders.transport.model.entity.HulledBoatModel;
import xyz.brassgoggledcoders.transport.model.item.EntityItemModelCache;
import xyz.brassgoggledcoders.transport.repack.registrate.util.nullness.NonNullSupplier;
import xyz.brassgoggledcoders.transport.util.CachedValue;

public class TugBoatRenderer<T extends TugBoatEntity>
extends EntityRenderer<T> {
    private static final HulledBoatModel<TugBoatEntity> BOAT_MODEL = new HulledBoatModel<TugBoatEntity>(entity -> true);
    private final ResourceLocation textureLocation;
    private final float scale;
    private final NonNullSupplier<? extends Item> itemSupplier;
    private CachedValue<IBakedModel> cachedBakedModel;

    public TugBoatRenderer(NonNullSupplier<? extends Item> itemSupplier, float scale, ResourceLocation textureLocation, EntityRendererManager renderManager) {
        super(renderManager);
        this.itemSupplier = itemSupplier;
        this.textureLocation = textureLocation;
        this.scale = scale;
        this.field_76989_e = 0.8f;
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int packedLight) {
        float f2;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.375, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityYaw));
        float f = (float)entity.func_70268_h() - partialTicks;
        float f1 = entity.func_70271_g() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)entity.func_70267_i()));
        }
        if (!MathHelper.func_180185_a((float)(f2 = entity.func_203056_b(partialTicks)), (float)0.0f)) {
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(1.0f, 0.0f, 1.0f), entity.func_203056_b(partialTicks), true));
        }
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        this.renderBoat(entity, partialTicks, matrixStack, buffer, packedLight);
        super.func_225623_a_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        matrixStack.func_227865_b_();
    }

    protected void renderBoat(T entity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        IBakedModel model = this.getCachedBakedModel(entity).getValue();
        if (model != null) {
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            Minecraft.func_71410_x().func_175599_af().func_229114_a_(model, ItemStack.field_190927_a, packedLight, OverlayTexture.field_229196_a_, matrixStack, buffer.getBuffer(RenderType.func_228645_f_()));
            if (!entity.func_204231_K()) {
                IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228651_i_());
                matrixStack.func_227862_a_(0.75f, 0.0f, 2.8f);
                matrixStack.func_227861_a_(0.0, 0.0, (double)-0.05f);
                BOAT_MODEL.func_228245_c_().func_228308_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_);
            }
            matrixStack.func_227865_b_();
        }
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull T entity) {
        return this.textureLocation;
    }

    public CachedValue<IBakedModel> getCachedBakedModel(@Nonnull T entity) {
        if (this.cachedBakedModel == null) {
            this.cachedBakedModel = EntityItemModelCache.getBakedModelCacheFor(this.itemSupplier.get());
        }
        return this.cachedBakedModel;
    }
}

