/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.pointmachine;

import com.mojang.datafixers.util.Either;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.pointmachine.IPointMachineBehavior;
import xyz.brassgoggledcoders.transport.api.predicate.PredicateStorage;

public class PredicatePointMachineBehavior
implements IPointMachineBehavior {
    @Override
    public boolean shouldDiverge(BlockState motorState, IBlockReader blockReader, BlockPos motorPos, BlockPos switchPos, @Nullable AbstractMinecartEntity minecartEntity) {
        TileEntity tileEntity;
        if (minecartEntity != null && motorPos.func_177972_a(((Direction)motorState.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176734_d()).equals((Object)switchPos) && (tileEntity = blockReader.func_175625_s(motorPos)) != null) {
            return tileEntity.getCapability(TransportAPI.PREDICATE_STORAGE).map(predicateStorage -> predicateStorage.getPredicate(tileEntity)).map(routing -> this.handleRouting((Either<String, Predicate<Entity>>)routing, minecartEntity)).orElse(false);
        }
        return false;
    }

    private Boolean handleRouting(Either<String, Predicate<Entity>> routing, AbstractMinecartEntity minecartEntity) {
        return routing.ifLeft(error -> {
            for (Entity entity : minecartEntity.func_184188_bt()) {
                if (!(entity instanceof PlayerEntity) || entity.func_130014_f_().func_201670_d()) continue;
                ((PlayerEntity)entity).func_146105_b((ITextComponent)new StringTextComponent(error), true);
            }
        }).mapRight(value -> value.test(minecartEntity)).right().orElse(false);
    }

    @Override
    public void onBlockStateUpdate(BlockState motorState, IBlockReader blockReader, BlockPos motorPos) {
        TileEntity tileEntity = blockReader.func_175625_s(motorPos);
        if (tileEntity != null) {
            tileEntity.getCapability(TransportAPI.PREDICATE_STORAGE).ifPresent(PredicateStorage::invalidate);
        }
    }
}

