/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.network.property;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import xyz.brassgoggledcoders.transport.Transport;
import xyz.brassgoggledcoders.transport.network.property.Property;

public class PropertyType<T>
implements Comparable<PropertyType<?>> {
    private final String name;
    private final Class<T> tClass;
    private final Function<PacketBuffer, T> reader;
    private final BiConsumer<PacketBuffer, T> writer;
    private final BiPredicate<T, T> equals;

    public PropertyType(String name, Class<T> tClass, Function<PacketBuffer, T> reader, BiConsumer<PacketBuffer, T> writer) {
        this(name, tClass, reader, writer, Objects::equals);
    }

    public PropertyType(String name, Class<T> tClass, Function<PacketBuffer, T> reader, BiConsumer<PacketBuffer, T> writer, BiPredicate<T, T> equals) {
        this.name = name;
        this.tClass = tClass;
        this.reader = reader;
        this.writer = writer;
        this.equals = equals;
    }

    public Function<PacketBuffer, T> getReader() {
        return this.reader;
    }

    public BiConsumer<PacketBuffer, T> getWriter() {
        return this.writer;
    }

    public BiPredicate<T, T> getEquals() {
        return this.equals;
    }

    public String getName() {
        return this.name;
    }

    public Property<T> create() {
        return new Property(this);
    }

    public Property<T> create(Supplier<T> getter) {
        return new Property<Object>(this, getter, value -> {});
    }

    public Property<T> create(Supplier<T> getter, Consumer<T> setter) {
        return new Property<T>(this, getter, setter);
    }

    public boolean isValid(Object object) {
        return this.tClass.isInstance(object);
    }

    public void attemptWrite(PacketBuffer packetBuffer, Object object) {
        if (this.tClass.isInstance(object)) {
            this.getWriter().accept(packetBuffer, (PacketBuffer)this.tClass.cast(object));
        } else {
            Transport.LOGGER.error("Attempted to Write with Invalid Object.");
        }
    }

    public void attemptSet(Object object, Property<?> property) {
        if (property.getPropertyType() == this && this.tClass.isInstance(object)) {
            try {
                property.set(this.tClass.cast(object));
            }
            catch (ClassCastException classCastException) {
                Transport.LOGGER.error("Failed to Set Container Property", (Throwable)classCastException);
            }
        }
    }

    @Override
    public int compareTo(PropertyType<?> o) {
        return String.CASE_INSENSITIVE_ORDER.compare(this.getName(), o.getName());
    }
}

