/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.network.property;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.IContainerListener;
import org.apache.commons.lang3.tuple.Triple;
import xyz.brassgoggledcoders.transport.Transport;
import xyz.brassgoggledcoders.transport.network.property.Property;
import xyz.brassgoggledcoders.transport.network.property.PropertyType;
import xyz.brassgoggledcoders.transport.network.property.UpdateClientContainerPropertiesMessage;
import xyz.brassgoggledcoders.transport.network.property.UpdateServerContainerPropertyMessage;

public class PropertyManager {
    private final List<Property<?>> properties;
    private final short windowId;

    public PropertyManager(short windowId) {
        this.windowId = windowId;
        this.properties = Lists.newArrayList();
    }

    public <T> Property<T> addTrackedProperty(Property<T> property) {
        this.properties.add(property);
        return property;
    }

    public <T> void updateServer(Property<T> property, T value) {
        short propertyId = -1;
        for (short i = 0; i < this.properties.size(); i = (short)((short)(i + 1))) {
            if (this.properties.get(i) != property) continue;
            propertyId = i;
        }
        property.set(value);
        Transport.instance.networkHandler.sendUpdateServerContainerProperties(new UpdateServerContainerPropertyMessage(this.windowId, property.getPropertyType(), propertyId, value));
    }

    public void sendChanges(Collection<IContainerListener> containerListeners, boolean firstTime) {
        ArrayList playerListeners = Lists.newArrayList();
        for (IContainerListener listener : containerListeners) {
            if (!(listener instanceof ServerPlayerEntity)) continue;
            playerListeners.add((ServerPlayerEntity)listener);
        }
        if (!playerListeners.isEmpty()) {
            ArrayList dirtyProperties = Lists.newArrayList();
            for (short i = 0; i < this.properties.size(); i = (short)(i + 1)) {
                Property<?> property = this.properties.get(i);
                if (!property.isDirty() && !firstTime) continue;
                dirtyProperties.add(Triple.of(property.getPropertyType(), (Object)i, property.get()));
            }
            if (!dirtyProperties.isEmpty()) {
                for (ServerPlayerEntity playerEntity : playerListeners) {
                    Transport.instance.networkHandler.sendUpdateClientContainerProperties(playerEntity, new UpdateClientContainerPropertiesMessage(this.windowId, dirtyProperties));
                }
            }
        }
    }

    public void update(PropertyType<?> propertyType, short propertyId, Object value) {
        Property<?> property;
        if (propertyId < this.properties.size() && (property = this.properties.get(propertyId)) != null && property.getPropertyType() == propertyType) {
            propertyType.attemptSet(value, property);
        }
    }
}

