/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.network;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;
import xyz.brassgoggledcoders.transport.api.module.ModuleSlot;

public class UpdateModuleInstanceMessage {
    private final int entityId;
    private final ModuleSlot moduleSlot;
    private final int type;
    private final CompoundNBT compoundNBT;

    public UpdateModuleInstanceMessage(int entityId, ModuleSlot moduleSlot, int type, @Nullable CompoundNBT compoundNBT) {
        this.entityId = entityId;
        this.moduleSlot = moduleSlot;
        this.type = type;
        this.compoundNBT = compoundNBT;
    }

    public static UpdateModuleInstanceMessage decode(PacketBuffer packetBuffer) {
        return new UpdateModuleInstanceMessage(packetBuffer.readInt(), (ModuleSlot)packetBuffer.readRegistryId(), packetBuffer.readInt(), packetBuffer.readBoolean() ? packetBuffer.func_150793_b() : null);
    }

    public static void encode(UpdateModuleInstanceMessage updateModuleInstanceMessage, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(updateModuleInstanceMessage.entityId);
        packetBuffer.writeRegistryId((IForgeRegistryEntry)updateModuleInstanceMessage.moduleSlot);
        packetBuffer.writeInt(updateModuleInstanceMessage.type);
        packetBuffer.writeBoolean(updateModuleInstanceMessage.compoundNBT != null);
        if (updateModuleInstanceMessage.compoundNBT != null) {
            packetBuffer.func_150786_a(updateModuleInstanceMessage.compoundNBT);
        }
    }

    public static boolean consume(UpdateModuleInstanceMessage updateModuleInstanceMessage, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            LogicalSide side = ((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide();
            ((Optional)LogicalSidedProvider.CLIENTWORLD.get(side)).map(world -> world.func_73045_a(updateModuleInstanceMessage.entityId)).ifPresent(entity -> entity.getCapability(TransportAPI.MODULAR_ENTITY).ifPresent(modularEntity -> {
                ModuleInstance<?> moduleInstance = modularEntity.getModuleInstance(updateModuleInstanceMessage.moduleSlot);
                if (moduleInstance != null) {
                    moduleInstance.receiveClientUpdate(updateModuleInstanceMessage.type, updateModuleInstanceMessage.compoundNBT);
                }
            }));
        });
        return true;
    }
}

