/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.item.locomotive;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import xyz.brassgoggledcoders.transport.content.TransportEntities;
import xyz.brassgoggledcoders.transport.content.TransportText;
import xyz.brassgoggledcoders.transport.entity.locomotive.SteamLocomotiveEntity;
import xyz.brassgoggledcoders.transport.item.locomotive.LocomotiveItem;
import xyz.brassgoggledcoders.transport.util.ItemStackHelper;

public class SteamLocomotiveItem
extends LocomotiveItem<SteamLocomotiveEntity> {
    public SteamLocomotiveItem(Item.Properties builder) {
        super(TransportEntities.STEAM_LOCOMOTIVE, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, tooltip, flagIn);
        CompoundNBT locomotiveData = stack.func_179543_a("locomotiveData");
        if (locomotiveData != null && locomotiveData.func_74764_b("engine")) {
            NonNullList<ItemStack> itemStacks;
            CompoundNBT engineNBT = locomotiveData.func_74775_l("engine");
            FluidStack water = FluidStack.loadFluidStackFromNBT((CompoundNBT)engineNBT.func_74775_l("waterTank"));
            CompoundNBT fuelHandler = engineNBT.func_74775_l("fuelHandler");
            boolean addedContents = false;
            if (fuelHandler.func_74764_b("Items") && (itemStacks = ItemStackHelper.loadItemStacks(fuelHandler)).size() > 0) {
                addedContents = true;
                tooltip.add(TransportText.TOOLTIP_CONTENTS);
                for (ItemStack itemStack : itemStacks) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.transport.contents.item", new Object[]{itemStack.func_190916_E(), itemStack.func_200301_q()}));
                }
            }
            if (!water.isEmpty()) {
                if (!addedContents) {
                    tooltip.add(TransportText.TOOLTIP_CONTENTS);
                }
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.transport.contents.fluid", new Object[]{water.getAmount(), water.getFluid().getAttributes().getDisplayName(water)}));
            }
        }
    }
}

