/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.event;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.FurnaceMinecartEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.LecternTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.brassgoggledcoders.transport.Transport;
import xyz.brassgoggledcoders.transport.api.TransportCapabilities;
import xyz.brassgoggledcoders.transport.api.predicate.PredicateStorageProvider;
import xyz.brassgoggledcoders.transport.capability.NBTCapabilityProvider;
import xyz.brassgoggledcoders.transport.capability.itemhandler.furnaceminecart.FurnaceMinecartFuelProvider;
import xyz.brassgoggledcoders.transport.content.TransportSounds;
import xyz.brassgoggledcoders.transport.navigation.NavigationNetwork;

@Mod.EventBusSubscriber(modid="transport", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    public static final ResourceLocation FURNACE_FUEL = Transport.rl("furnace_fuel");
    public static final ResourceLocation PREDICATE_STORAGE = Transport.rl("predicate_storage");
    public static final ResourceLocation NAVIGATION_NETWORK = Transport.rl("navigation_network");

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> entityAttachCapabilitiesEvent) {
        if (entityAttachCapabilitiesEvent.getObject() instanceof FurnaceMinecartEntity) {
            FurnaceMinecartFuelProvider fuelProvider = new FurnaceMinecartFuelProvider((FurnaceMinecartEntity)entityAttachCapabilitiesEvent.getObject());
            entityAttachCapabilitiesEvent.addCapability(FURNACE_FUEL, (ICapabilityProvider)fuelProvider);
            entityAttachCapabilitiesEvent.addListener(fuelProvider::invalidate);
        }
    }

    @SubscribeEvent
    public static void onAttachTileEntityCapabilities(AttachCapabilitiesEvent<TileEntity> attachCapabilitiesEvent) {
        if (attachCapabilitiesEvent.getObject() instanceof LecternTileEntity) {
            PredicateStorageProvider storageProvider = new PredicateStorageProvider();
            attachCapabilitiesEvent.addCapability(PREDICATE_STORAGE, (ICapabilityProvider)storageProvider);
            attachCapabilitiesEvent.addListener(storageProvider::invalidate);
        }
    }

    @SubscribeEvent
    public static void onAttachWorldCapabilities(AttachCapabilitiesEvent<World> attachCapabilitiesEvent) {
        NBTCapabilityProvider<NavigationNetwork> networkProvider = new NBTCapabilityProvider<NavigationNetwork>(TransportCapabilities.NAVIGATION_NETWORK, new NavigationNetwork());
        attachCapabilitiesEvent.addCapability(NAVIGATION_NETWORK, networkProvider);
        attachCapabilitiesEvent.addListener(networkProvider::invalidate);
    }

    @SubscribeEvent
    public static void onNoteBlockPlayer(NoteBlockEvent.Play playEvent) {
        if (playEvent.getInstrument().equals((Object)NoteBlockInstrument.HARP) && playEvent.getWorld().func_180495_p(playEvent.getPos().func_177977_b()).func_235714_a_((ITag)BlockTags.field_203437_y)) {
            playEvent.setCanceled(true);
            int i = playEvent.getVanillaNoteId();
            float f = (float)Math.pow(2.0, (double)(i - 12) / 12.0);
            BlockPos pos = playEvent.getPos();
            playEvent.getWorld().func_184133_a(null, pos, TransportSounds.WHISTLE.get(), SoundCategory.RECORDS, 3.0f, f);
            if (playEvent.getWorld() instanceof ServerWorld) {
                ((ServerWorld)playEvent.getWorld()).func_195598_a((IParticleData)ParticleTypes.field_197597_H, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, 1, 0.0, 1.0, 0.0, (double)i / 24.0);
            }
        }
    }
}

