/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.engine;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import xyz.brassgoggledcoders.transport.api.engine.EngineState;
import xyz.brassgoggledcoders.transport.capability.itemhandler.FuelItemStackHandler;
import xyz.brassgoggledcoders.transport.engine.Engine;

public class SteamEngine
extends Engine
implements ICapabilityProvider {
    public static final int WATER_CAPACITY = 7000;
    private final FluidTank waterTank = new FluidTank(7000, fluidStack -> fluidStack.getFluid().func_207185_a((ITag)FluidTags.field_206959_a));
    private final FuelItemStackHandler fuelHandler = new FuelItemStackHandler(1);
    private final BooleanSupplier isOn;
    private final LazyOptional<IFluidHandler> fluidLazy;
    private final LazyOptional<IItemHandler> itemLazy;
    private int burnRemaining;
    private int maxBurn;
    private double steam;
    private int ticksToNextWater;

    public SteamEngine(BooleanSupplier isOn) {
        this.isOn = isOn;
        this.fluidLazy = LazyOptional.of(() -> this.waterTank);
        this.itemLazy = LazyOptional.of(() -> this.fuelHandler);
    }

    @Override
    public void tick() {
        if (this.isOn.getAsBoolean()) {
            int burnAttempts;
            int n = burnAttempts = this.steam < 4100.0 ? 2 : 1;
            if (this.steam < 4200.0) {
                while (burnAttempts-- > 0) {
                    if (this.burnRemaining > 0) {
                        --this.burnRemaining;
                        if (this.ticksToNextWater > 0) {
                            --this.ticksToNextWater;
                            this.steam += 1.0;
                            continue;
                        }
                        if (this.waterTank.drain(1, IFluidHandler.FluidAction.EXECUTE).isEmpty()) continue;
                        this.ticksToNextWater = 20;
                        this.steam += 1.0;
                        continue;
                    }
                    if (this.waterTank.getFluidAmount() <= 0) continue;
                    this.burnRemaining = this.maxBurn = this.fuelHandler.burnFuel();
                }
            }
        } else {
            if (this.burnRemaining > 0) {
                --this.burnRemaining;
            }
            if (this.steam > 0.0) {
                this.steam -= 0.4;
            }
        }
    }

    public IItemHandler getFuelHandler() {
        return this.fuelHandler;
    }

    public FluidTank getWaterTank() {
        return this.waterTank;
    }

    public double getSteam() {
        return this.steam;
    }

    public int getBurnRemaining() {
        return this.burnRemaining;
    }

    public int getMaxBurn() {
        return this.maxBurn;
    }

    @Override
    public boolean pullPower(EngineState engineState) {
        this.steam -= (double)engineState.getFuelUseModifier();
        return this.steam > 2000.0;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("fuelHandler", (INBT)this.fuelHandler.serializeNBT());
        nbt.func_74768_a("burnRemaining", this.burnRemaining);
        nbt.func_74768_a("maxBurn", this.maxBurn);
        nbt.func_218657_a("waterTank", (INBT)this.waterTank.writeToNBT(new CompoundNBT()));
        nbt.func_74780_a("steam", this.steam);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.fuelHandler.deserializeNBT(nbt.func_74775_l("fuelHandler"));
        this.burnRemaining = nbt.func_74762_e("burnRemaining");
        this.maxBurn = nbt.func_74762_e("maxBurn");
        this.waterTank.readFromNBT(nbt.func_74775_l("waterTank"));
        this.steam = nbt.func_74769_h("steam");
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemLazy.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidLazy.cast();
        }
        return LazyOptional.empty();
    }

    public void invalidateCaps() {
        this.fluidLazy.invalidate();
        this.itemLazy.invalidate();
    }
}

