/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.compat.vanilla.module.cargo;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModule;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModuleInstance;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.content.TransportSounds;

public class NoteBlockCargoModuleInstance
extends CargoModuleInstance {
    private SoundEvent soundEvent = NoteBlockInstrument.HARP.func_208088_a();
    private int note = 0;
    private int lastNote = 0;

    public NoteBlockCargoModuleInstance(CargoModule cargoModule, IModularEntity modularEntity) {
        super(cargoModule, modularEntity);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.lastNote > 0) {
            --this.lastNote;
        }
    }

    @Override
    public ActionResultType applyInteraction(PlayerEntity player, Vector3d vec, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() instanceof BlockItem) {
            BlockState blockState = ((BlockItem)heldItem.func_77973_b()).func_179223_d().func_176223_P();
            SoundEvent newSoundEvent = blockState.func_235714_a_((ITag)BlockTags.field_203437_y) ? TransportSounds.WHISTLE.get() : NoteBlockInstrument.func_208087_a((BlockState)blockState).func_208088_a();
            if (newSoundEvent != this.soundEvent) {
                this.soundEvent = newSoundEvent;
            } else {
                ++this.note;
                if (this.note > 24) {
                    this.note = 0;
                }
            }
            return ActionResultType.SUCCESS;
        }
        ++this.note;
        if (this.note > 24) {
            this.note = 0;
        }
        return super.applyInteraction(player, vec, hand);
    }

    @Override
    public void onActivatorPass(boolean receivingPower) {
        if (receivingPower && this.lastNote <= 0) {
            float f = (float)Math.pow(2.0, (double)(this.note - 12) / 12.0);
            BlockPos pos = this.getModularEntity().getSelf().func_233580_cy_();
            this.getWorld().func_184133_a(null, pos, this.soundEvent, SoundCategory.RECORDS, 3.0f, f);
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_218657_a("blockPos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
            compoundNBT.func_74768_a("note", this.note);
            this.sendClientUpdate(0, compoundNBT);
        }
        this.lastNote = 20;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_74768_a("note", this.note);
        nbt.func_74778_a("soundEvent", Objects.requireNonNull(this.soundEvent.getRegistryName()).toString());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.note = nbt.func_74762_e("note");
        this.soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(nbt.func_74779_i("soundEvent")));
        if (this.soundEvent == null) {
            this.soundEvent = NoteBlockInstrument.HARP.func_208088_a();
        }
    }

    @Override
    public void receiveClientUpdate(int type, @Nullable CompoundNBT compoundNBT) {
        super.receiveClientUpdate(type, compoundNBT);
        if (type == 0 && compoundNBT != null) {
            BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)compoundNBT.func_74775_l("blockPos"));
            int note = compoundNBT.func_74762_e("note");
            this.getWorld().func_195594_a((IParticleData)ParticleTypes.field_197597_H, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, (double)note / 24.0, 0.0, 0.0);
        }
    }
}

