/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.capability.itemhandler;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.item.IModularItem;
import xyz.brassgoggledcoders.transport.api.module.Module;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;
import xyz.brassgoggledcoders.transport.api.module.ModuleSlot;

public class ModularItemStackHandler
implements IItemHandlerModifiable,
INBTSerializable<CompoundNBT> {
    private final Supplier<World> world;
    private final Runnable onChange;
    private boolean needsUpdate;
    private LazyOptional<IModularEntity> modularEntity;
    private ItemStack modularItemStack;

    public ModularItemStackHandler(Supplier<World> world) {
        this(world, () -> {});
    }

    public ModularItemStackHandler(Supplier<World> world, Runnable onChange) {
        this.world = world;
        this.onChange = onChange;
        this.modularEntity = LazyOptional.empty();
        this.modularItemStack = ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (slot == 0) {
            this.modularItemStack = stack;
            this.onChange();
        } else {
            this.getModularEntity().ifPresent(value -> {
                ModuleSlot moduleSlot = this.getModuleSlot((IModularEntity)value, slot);
                if (moduleSlot != null) {
                    if (!stack.func_190926_b()) {
                        Module<?> module = TransportAPI.getModuleFromItem(stack.func_77973_b());
                        if (module != null) {
                            value.remove(moduleSlot, false);
                            ModuleInstance<?> moduleInstance = value.add(module, moduleSlot, false);
                            if (moduleInstance != null) {
                                moduleInstance.readFromItemStack(stack);
                            }
                            this.writeChanges((IModularEntity)value);
                            this.onChange();
                        }
                    } else {
                        value.remove(moduleSlot, false);
                        this.writeChanges((IModularEntity)value);
                        this.onChange();
                    }
                }
            });
        }
    }

    public int getSlots() {
        return 1 + this.getModularEntity().map(IModularEntity::getModuleSlots).map(List::size).orElse(0);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot == 0) {
            return this.modularItemStack;
        }
        return this.getModularEntity().map(entity -> {
            ModuleInstance<?> moduleInstance;
            ModuleSlot moduleSlot = this.getModuleSlot((IModularEntity)entity, slot);
            if (moduleSlot != null && (moduleInstance = entity.getModuleInstance(moduleSlot)) != null) {
                return moduleInstance.asItemStack();
            }
            return ItemStack.field_190927_a;
        }).orElse(ItemStack.field_190927_a);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack itemStack, boolean simulate) {
        if (slot == 0 && this.modularItemStack.func_190926_b()) {
            ItemStack copiedStack = itemStack.func_77946_l();
            ItemStack inserted = copiedStack.func_77979_a(1);
            if (!simulate) {
                this.modularItemStack = inserted;
                this.onChange();
            }
            return copiedStack;
        }
        if (slot > 0) {
            return this.getModularEntity().filter(value -> this.isItemValid(slot, itemStack)).map(value -> {
                ModuleSlot moduleSlot = this.getModuleSlot((IModularEntity)value, slot);
                if (moduleSlot != null) {
                    ItemStack newStack = itemStack.func_77946_l();
                    newStack.func_190918_g(1);
                    if (!simulate) {
                        Module<?> module = TransportAPI.getModuleFromItem(itemStack.func_77973_b());
                        value.add(module, moduleSlot, false);
                        this.writeChanges((IModularEntity)value);
                        this.onChange();
                    }
                    return newStack;
                }
                return itemStack;
            }).orElse(itemStack);
        }
        return itemStack;
    }

    private void writeChanges(IModularEntity modularEntity) {
        if (!this.modularItemStack.func_190926_b()) {
            this.modularItemStack.func_196082_o().func_218657_a("modules", modularEntity.serializeNBT());
        }
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 0) {
            ItemStack extracted = this.modularItemStack;
            if (!simulate) {
                this.modularItemStack = ItemStack.field_190927_a;
                this.onChange();
            }
            return extracted;
        }
        if (slot > 0) {
            return this.getModularEntity().map(value -> {
                ModuleSlot moduleSlot = this.getModuleSlot((IModularEntity)value, slot);
                ModuleInstance<?> moduleInstance = value.getModuleInstance(moduleSlot);
                if (moduleInstance != null) {
                    ItemStack itemStack = moduleInstance.asItemStack();
                    if (!simulate) {
                        value.remove(moduleSlot, false);
                        this.writeChanges((IModularEntity)value);
                        this.onChange();
                    }
                    return itemStack;
                }
                return ItemStack.field_190927_a;
            }).orElse(ItemStack.field_190927_a);
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (slot == 0) {
            return stack.func_77973_b() instanceof IModularItem;
        }
        if (slot > 0 && !stack.func_190926_b()) {
            return this.getModularEntity().map(value -> {
                ModuleSlot moduleSlot = this.getModuleSlot((IModularEntity)value, slot);
                Module<?> module = TransportAPI.getModuleFromItem(stack.func_77973_b());
                if (module != null && moduleSlot != null) {
                    return value.canEquip(module) && module.isValidFor((IModularEntity)value) && moduleSlot.isModuleValid((IModularEntity)value, module);
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public CompoundNBT serializeNBT() {
        return this.modularItemStack.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("Items")) {
            ListNBT items = nbt.func_150295_c("Items", 10);
            if (!items.isEmpty()) {
                this.modularItemStack = ItemStack.func_199557_a((CompoundNBT)items.func_150305_b(0));
            }
        } else {
            this.modularItemStack = ItemStack.func_199557_a((CompoundNBT)nbt);
        }
        this.needsUpdate = true;
    }

    public LazyOptional<IModularEntity> getModularEntity() {
        this.checkNeedsUpdate();
        return this.modularEntity;
    }

    private void checkNeedsUpdate() {
        if (this.needsUpdate) {
            if (this.modularItemStack.func_190926_b()) {
                this.modularEntity = LazyOptional.empty();
            } else if (this.modularItemStack.func_77973_b() instanceof IModularItem) {
                Entity entity = ((IModularItem)this.modularItemStack.func_77973_b()).getEntityType().func_200721_a(Objects.requireNonNull(this.world.get()));
                CompoundNBT instanceNBT = this.modularItemStack.func_179543_a("modules");
                if (entity != null) {
                    this.modularEntity = entity.getCapability(TransportAPI.MODULAR_ENTITY);
                    if (instanceNBT != null) {
                        this.modularEntity.ifPresent(value -> value.deserializeNBT((INBT)instanceNBT));
                    }
                }
            }
            this.needsUpdate = false;
        }
    }

    private void onChange() {
        this.needsUpdate = true;
        this.onChange.run();
    }

    @Nullable
    private ModuleSlot getModuleSlot(IModularEntity entity, int slot) {
        List<ModuleSlot> moduleSlots = entity.getModuleSlots();
        int actualSlot = slot - 1;
        if (actualSlot >= 0 && moduleSlots.size() > actualSlot) {
            return moduleSlots.get(actualSlot);
        }
        return null;
    }

    public List<ModuleSlot> getAvailableModuleSlots() {
        return this.getModularEntity().map(IModularEntity::getModuleSlots).orElseGet(Lists::newArrayList);
    }

    public void forEach(Consumer<ItemStack> itemStackConsumer) {
        itemStackConsumer.accept(this.modularItemStack);
        this.modularItemStack = ItemStack.field_190927_a;
        this.onChange();
    }
}

