/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.block.rail.turnout;

import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import xyz.brassgoggledcoders.transport.block.rail.turnout.AbstractSwitchRailBlock;
import xyz.brassgoggledcoders.transport.block.rail.turnout.SwitchConfiguration;
import xyz.brassgoggledcoders.transport.util.BlockStateHelper;

public class SwitchRailBlock
extends AbstractSwitchRailBlock {
    public static final EnumProperty<RailShape> DIVERGE_SHAPE = EnumProperty.func_177708_a((String)"diverge_shape", RailShape.class, railShape -> railShape == RailShape.NORTH_EAST || railShape == RailShape.SOUTH_EAST || railShape == RailShape.SOUTH_WEST || railShape == RailShape.NORTH_WEST);
    public static final EnumProperty<RailShape> STRAIGHT_SHAPE = EnumProperty.func_177708_a((String)"straight_shape", RailShape.class, railShape -> railShape == RailShape.NORTH_SOUTH || railShape == RailShape.EAST_WEST);

    public SwitchRailBlock(AbstractBlock.Properties properties) {
        super(true, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(STRAIGHT_SHAPE, (Comparable)RailShape.NORTH_SOUTH)).func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.SOUTH_EAST)).func_206870_a((Property)DIVERGE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STRAIGHT_SHAPE, DIVERGE_SHAPE, DIVERGE});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockState = this.func_176223_P();
        Direction[] nearestDirections = context.func_196009_e();
        if (nearestDirections.length >= 3) {
            Direction secondClosest;
            Direction firstClosest;
            int currentCheck = 0;
            if ((firstClosest = nearestDirections[currentCheck++]).func_176740_k() == Direction.Axis.Y) {
                firstClosest = nearestDirections[currentCheck++];
            }
            if ((secondClosest = nearestDirections[currentCheck++]).func_176740_k() == Direction.Axis.Y) {
                secondClosest = nearestDirections[currentCheck];
            }
            if (firstClosest == Direction.NORTH) {
                blockState = (BlockState)blockState.func_206870_a(STRAIGHT_SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                blockState = secondClosest == Direction.EAST ? (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.SOUTH_EAST) : (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.SOUTH_WEST);
            } else if (firstClosest == Direction.SOUTH) {
                blockState = (BlockState)blockState.func_206870_a(STRAIGHT_SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                blockState = secondClosest == Direction.EAST ? (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.NORTH_EAST) : (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.NORTH_WEST);
            } else if (firstClosest == Direction.WEST) {
                blockState = (BlockState)blockState.func_206870_a(STRAIGHT_SHAPE, (Comparable)RailShape.EAST_WEST);
                blockState = secondClosest == Direction.NORTH ? (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.NORTH_EAST) : (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.SOUTH_EAST);
            } else if (firstClosest == Direction.EAST) {
                blockState = (BlockState)blockState.func_206870_a(STRAIGHT_SHAPE, (Comparable)RailShape.EAST_WEST);
                blockState = secondClosest == Direction.NORTH ? (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.NORTH_WEST) : (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.SOUTH_WEST);
            }
        }
        return blockState;
    }

    @Nonnull
    public Property<RailShape> func_176560_l() {
        return STRAIGHT_SHAPE;
    }

    @Override
    protected RailShape getStraightShape(SwitchConfiguration switchConfiguration) {
        return switchConfiguration.getStraight();
    }

    @Override
    protected SwitchConfiguration getSwitchConfiguration(BlockState blockState) {
        return SwitchConfiguration.get((RailShape)blockState.func_177229_b(STRAIGHT_SHAPE), (RailShape)blockState.func_177229_b(DIVERGE_SHAPE));
    }

    @Override
    protected Direction getMotorDirection(SwitchConfiguration switchConfiguration) {
        return switchConfiguration.getDivergentSide().func_176734_d();
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                state = (BlockState)((BlockState)state.func_235896_a_(DIVERGE_SHAPE)).func_235896_a_(DIVERGE_SHAPE);
                break;
            }
            case CLOCKWISE_90: {
                RailShape clockwiseShape = (RailShape)state.func_177229_b(STRAIGHT_SHAPE);
                switch ((RailShape)state.func_177229_b(DIVERGE_SHAPE)) {
                    case NORTH_EAST: 
                    case SOUTH_WEST: {
                        if (clockwiseShape == RailShape.NORTH_SOUTH) {
                            state = (BlockState)state.func_206870_a(STRAIGHT_SHAPE, (Comparable)RailShape.EAST_WEST);
                            break;
                        }
                        state = (BlockState)state.func_235896_a_(DIVERGE_SHAPE);
                        break;
                    }
                    case SOUTH_EAST: 
                    case NORTH_WEST: {
                        state = clockwiseShape == RailShape.EAST_WEST ? (BlockState)state.func_206870_a(STRAIGHT_SHAPE, (Comparable)RailShape.NORTH_SOUTH) : (BlockState)state.func_235896_a_(DIVERGE_SHAPE);
                    }
                }
                break;
            }
            case COUNTERCLOCKWISE_90: {
                RailShape counterClockWiseShape = (RailShape)state.func_177229_b(STRAIGHT_SHAPE);
                switch ((RailShape)state.func_177229_b(DIVERGE_SHAPE)) {
                    case NORTH_EAST: 
                    case SOUTH_WEST: {
                        if (counterClockWiseShape == RailShape.EAST_WEST) {
                            state = (BlockState)state.func_206870_a(STRAIGHT_SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                            break;
                        }
                        state = BlockStateHelper.cyclePrevious(state, DIVERGE_SHAPE);
                        break;
                    }
                    case SOUTH_EAST: 
                    case NORTH_WEST: {
                        state = counterClockWiseShape == RailShape.NORTH_SOUTH ? (BlockState)state.func_206870_a(STRAIGHT_SHAPE, (Comparable)RailShape.EAST_WEST) : BlockStateHelper.cyclePrevious(state, DIVERGE_SHAPE);
                    }
                }
                break;
            }
        }
        return state;
    }
}

