/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.block.rail.elevatorswitch;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.brassgoggledcoders.transport.block.rail.elevatorswitch.ElevatorSwitchRailBlock;
import xyz.brassgoggledcoders.transport.content.TransportBlocks;

public class ElevatorSwitchSupportBlock
extends Block {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public ElevatorSwitchSupportBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @ParametersAreNonnullByDefault
    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        this.updateState((World)world, pos, true);
    }

    @ParametersAreNonnullByDefault
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.updateState(worldIn, pos, false);
    }

    private void updateState(World world, BlockPos pos, boolean doRemoval) {
        boolean powered = world.func_175640_z(pos);
        BlockState blockState = world.func_180495_p(pos.func_177984_a());
        if (blockState.func_177230_c() == TransportBlocks.ELEVATOR_SWITCH_RAIL.get()) {
            if (!powered) {
                BlockState railState = (BlockState)ElevatorSwitchRailBlock.oppositeAscend(blockState).func_206870_a((Property)ElevatorSwitchRailBlock.TOP, (Comparable)Boolean.valueOf(false));
                world.func_175656_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
                world.func_175656_a(pos, railState);
            }
        } else if (doRemoval) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }
}

