/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.block.boat;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xyz.brassgoggledcoders.transport.content.TransportBlocks;
import xyz.brassgoggledcoders.transport.tileentity.boat.BuoyTileEntity;

public class BuoyBlock
extends Block {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final VoxelShape TOP = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197873_a((double)0.375, (double)0.65625, (double)0.375, (double)0.625, (double)0.96875, (double)0.625), (VoxelShape)VoxelShapes.func_197873_a((double)0.21875, (double)0.0, (double)0.21875, (double)0.78125, (double)0.6875, (double)0.78125));
    public static final VoxelShape BOTTOM = VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197873_a((double)0.21875, (double)0.375, (double)0.21875, (double)0.78125, (double)1.0, (double)0.78125), (VoxelShape[])new VoxelShape[]{VoxelShapes.func_197873_a((double)0.1875, (double)0.25, (double)0.1875, (double)0.8125, (double)0.375, (double)0.8125), VoxelShapes.func_197873_a((double)0.03125, (double)0.0, (double)0.03125, (double)0.96875, (double)0.25, (double)0.96875)});

    public BuoyBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HALF});
    }

    @Nullable
    public BlockState func_196258_a(@Nonnull BlockItemUseContext context) {
        if (context.func_195991_k().func_180495_p(context.func_195995_a().func_177984_a()).func_196953_a(context)) {
            return this.func_176223_P();
        }
        return null;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof BuoyTileEntity) {
            ((BuoyTileEntity)tileEntity).setup(placer instanceof PlayerEntity ? (PlayerEntity)placer : null);
        }
    }

    @ParametersAreNonnullByDefault
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof BuoyTileEntity) {
                ((BuoyTileEntity)tileentity).destroy();
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tileEntity;
        BlockPos blockPos = pos;
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            blockPos = blockPos.func_177977_b();
        }
        if ((tileEntity = world.func_175625_s(blockPos)) instanceof BuoyTileEntity) {
            ((BuoyTileEntity)tileEntity).interact(player);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (context.getEntity() instanceof BoatEntity) {
            return VoxelShapes.func_197880_a();
        }
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            return TOP;
        }
        return BOTTOM;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public BlockState func_196271_a(BlockState blockState, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return !blockState.func_196955_c((IWorldReader)world, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(blockState, facing, facingState, world, currentPos, facingPos);
    }

    @ParametersAreNonnullByDefault
    public boolean func_196260_a(BlockState blockState, IWorldReader worldReader, BlockPos blockPos) {
        BlockPos downBlockPos = blockPos.func_177977_b();
        if (blockState.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return worldReader.func_204610_c(downBlockPos).func_206886_c().func_207185_a((ITag)FluidTags.field_206959_a);
        }
        return worldReader.func_180495_p(downBlockPos).func_177230_c() == this;
    }

    public static int getLightLevel(BlockState blockState) {
        return blockState.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? 5 : 0;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? new BuoyTileEntity(TransportBlocks.BUOY_TILE_ENTITY.get()) : null;
    }

    public boolean hasTileEntity(BlockState state) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
    }
}

