/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.predicate;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.functional.ThrowingFunction;
import xyz.brassgoggledcoders.transport.api.predicate.PredicateParserException;

public class PredicateParser {
    private static final Predicate<String> STRING_PATTERN = Pattern.compile("^\\s*\".+\".*").asPredicate();
    private static final Predicate<String> PREDICATE_START_PATTERN = Pattern.compile("^\\s*\\w+\\s*\\{.*").asPredicate();
    private static final Predicate<String> NUMBER_PATTERN = Pattern.compile("^\\s*\\d*.*").asPredicate();
    private final Function<String, ThrowingFunction<PredicateParser, Predicate<Entity>, PredicateParserException>> getEntityPredicateCreator;
    private final Function<String, ThrowingFunction<PredicateParser, Predicate<String>, PredicateParserException>> getStringPredicateCreator;
    private final String parsing;
    private int parsedLocation;

    private PredicateParser(String parsing) {
        this(parsing, TransportAPI::getEntityPredicateCreator, TransportAPI::getStringPredicateCreator);
    }

    private PredicateParser(String parsing, Function<String, ThrowingFunction<PredicateParser, Predicate<Entity>, PredicateParserException>> getEntityPredicateCreator, Function<String, ThrowingFunction<PredicateParser, Predicate<String>, PredicateParserException>> getStringPredicateCreator) {
        this.parsing = parsing;
        this.parsedLocation = 0;
        this.getStringPredicateCreator = getStringPredicateCreator;
        this.getEntityPredicateCreator = getEntityPredicateCreator;
    }

    public String getNextString() throws PredicateParserException {
        int startQuoteIndex = this.parsing.indexOf(34, this.parsedLocation);
        if (startQuoteIndex < 0) {
            throw new PredicateParserException("Failed to Find Start of String");
        }
        int endQuoteIndex = this.parsing.indexOf(34, startQuoteIndex + 1);
        if (endQuoteIndex < 0) {
            throw new PredicateParserException("Failed to Find End of String");
        }
        this.parsedLocation = endQuoteIndex + 1;
        return this.parsing.substring(startQuoteIndex + 1, endQuoteIndex);
    }

    public boolean hasNextString() {
        return STRING_PATTERN.test(this.parsing.substring(this.parsedLocation));
    }

    public int getNextInt() throws PredicateParserException {
        boolean foundNumber = false;
        int startIndex = this.parsedLocation;
        int endIndex = -1;
        while (endIndex < 0) {
            char currentChar = this.parsing.charAt(this.parsedLocation);
            if (Character.isWhitespace(currentChar)) {
                if (foundNumber) {
                    endIndex = this.parsedLocation;
                }
            } else if (Character.isDigit(currentChar)) {
                foundNumber = true;
            }
            this.nextParseLocation();
        }
        String numberToParse = this.parsing.substring(startIndex, endIndex).trim();
        try {
            return Integer.parseInt(numberToParse);
        }
        catch (NumberFormatException exception) {
            throw new PredicateParserException(numberToParse + " is not a valid number");
        }
    }

    public boolean hasNextInt() {
        return NUMBER_PATTERN.test(this.parsing.substring(this.parsedLocation));
    }

    public Predicate<Entity> getNextEntityPredicate() throws PredicateParserException {
        return this.getNextPredicate(this.getEntityPredicateCreator);
    }

    public Predicate<String> getNextStringPredicate() throws PredicateParserException {
        return this.getNextPredicate(this.getStringPredicateCreator);
    }

    public boolean hasNextPredicate() {
        return PREDICATE_START_PATTERN.test(this.parsing.substring(this.parsedLocation));
    }

    public <T> Predicate<T> getNextPredicate(Function<String, ThrowingFunction<PredicateParser, Predicate<T>, PredicateParserException>> getPredicateCreator) throws PredicateParserException {
        int startBracketIndex = this.parsing.indexOf(123, this.parsedLocation);
        if (startBracketIndex < 0) {
            throw new PredicateParserException("Failed to Find Start { of Predicate");
        }
        String predicateName = this.parsing.substring(this.parsedLocation, startBracketIndex).trim();
        ThrowingFunction<PredicateParser, Predicate<PredicateParser>, PredicateParserException> predicateCreator = getPredicateCreator.apply(predicateName);
        if (predicateCreator == null) {
            throw new PredicateParserException("Failed to Find Predicate for Name: " + predicateName);
        }
        int numberOfOpenPredicates = 1;
        this.parsedLocation = startBracketIndex;
        while (numberOfOpenPredicates > 0) {
            this.nextParseLocation();
            char charAt = this.parsing.charAt(this.parsedLocation);
            if (charAt == '}') {
                --numberOfOpenPredicates;
                continue;
            }
            if (charAt != '{') continue;
            ++numberOfOpenPredicates;
        }
        return predicateCreator.apply(PredicateParser.fromString(this.parsing.substring(startBracketIndex + 1, this.parsedLocation++)));
    }

    private void nextParseLocation() throws PredicateParserException {
        ++this.parsedLocation;
        if (this.parsedLocation > this.parsing.length()) {
            throw new PredicateParserException("Failed to Find Closing } of Predicate");
        }
    }

    public static PredicateParser fromString(String parsing) {
        return new PredicateParser(parsing);
    }
}

