/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.module.Module;
import xyz.brassgoggledcoders.transport.api.module.ModuleSlot;

public interface IModularItem<T extends Entity> {
    public EntityType<T> getEntityType();

    default public Collection<ITextComponent> getModuleListToolTip(CompoundNBT modulesNBT) {
        ListNBT moduleInstancesNBT;
        ArrayList toolTips = Lists.newArrayList();
        if (modulesNBT != null && (moduleInstancesNBT = modulesNBT.func_150295_c("moduleInstances", 10)).size() > 0) {
            toolTips.add(new TranslationTextComponent("text.transport.installed_modules"));
            for (int x = 0; x < moduleInstancesNBT.size(); ++x) {
                CompoundNBT moduleInstanceNBT = moduleInstancesNBT.func_150305_b(x);
                Module<?> module = Module.fromCompoundNBT(moduleInstanceNBT);
                ModuleSlot moduleSlot = TransportAPI.getModuleSlot(moduleInstanceNBT.func_74779_i("moduleSlot"));
                if (module == null || moduleSlot == null) continue;
                toolTips.add(new TranslationTextComponent("text.transport.installed_module", new Object[]{moduleSlot.getDisplayName(), module.getDisplayName()}));
            }
        }
        return toolTips;
    }
}

