/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.api;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.brassgoggledcoders.transport.api.cargo.CargoModule;
import xyz.brassgoggledcoders.transport.api.connection.IConnectionChecker;
import xyz.brassgoggledcoders.transport.api.connection.ListConnectionChecker;
import xyz.brassgoggledcoders.transport.api.connection.NoConnectionChecker;
import xyz.brassgoggledcoders.transport.api.engine.EngineModule;
import xyz.brassgoggledcoders.transport.api.entity.HullType;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.functional.ThrowingFunction;
import xyz.brassgoggledcoders.transport.api.module.Module;
import xyz.brassgoggledcoders.transport.api.module.ModuleSlot;
import xyz.brassgoggledcoders.transport.api.module.ModuleType;
import xyz.brassgoggledcoders.transport.api.network.INetworkHandler;
import xyz.brassgoggledcoders.transport.api.pointmachine.IPointMachineBehavior;
import xyz.brassgoggledcoders.transport.api.predicate.PredicateParser;
import xyz.brassgoggledcoders.transport.api.predicate.PredicateParserException;
import xyz.brassgoggledcoders.transport.api.predicate.PredicateStorage;

public class TransportAPI {
    public static final Logger LOGGER = LogManager.getLogger((String)"transport-api");
    @CapabilityInject(value=PredicateStorage.class)
    public static Capability<PredicateStorage> PREDICATE_STORAGE;
    @CapabilityInject(value=IModularEntity.class)
    public static Capability<IModularEntity> MODULAR_ENTITY;
    private static IConnectionChecker connectionChecker;
    private static INetworkHandler networkHandler;
    private static final Map<Block, IPointMachineBehavior> POINT_MACHINE_BEHAVIORS;
    private static final Map<String, ThrowingFunction<PredicateParser, Predicate<Entity>, PredicateParserException>> ENTITY_PREDICATE_CREATORS;
    private static final Map<String, ThrowingFunction<PredicateParser, Predicate<String>, PredicateParserException>> STRING_PREDICATE_CREATORS;
    private static final Map<Item, Module<?>> ITEM_TO_MODULE;
    public static Lazy<ForgeRegistry<CargoModule>> CARGO;
    public static Lazy<IForgeRegistry<EngineModule>> ENGINES;
    public static Lazy<IForgeRegistry<ModuleType>> MODULE_TYPE;
    public static Lazy<IForgeRegistry<ModuleSlot>> MODULE_SLOT;
    public static Lazy<IForgeRegistry<HullType>> HULL_TYPE;

    public static CargoModule getCargo(String name) {
        return TransportAPI.getCargo(new ResourceLocation(name));
    }

    public static CargoModule getCargo(ResourceLocation name) {
        return (CargoModule)((ForgeRegistry)CARGO.get()).getValue(name);
    }

    public static Collection<CargoModule> getCargo() {
        return ((ForgeRegistry)CARGO.get()).getValues();
    }

    public static EngineModule getEngine(String name) {
        return TransportAPI.getEngine(new ResourceLocation(name));
    }

    public static EngineModule getEngine(ResourceLocation name) {
        return (EngineModule)((IForgeRegistry)ENGINES.get()).getValue(name);
    }

    public static Collection<EngineModule> getEngines() {
        return ((IForgeRegistry)ENGINES.get()).getValues();
    }

    public static ModuleType getModuleType(String name) {
        return TransportAPI.getModuleType(new ResourceLocation(name));
    }

    public static ModuleType getModuleType(ResourceLocation resourceLocation) {
        return (ModuleType)((IForgeRegistry)MODULE_TYPE.get()).getValue(resourceLocation);
    }

    public static void addEntityPredicateCreator(String name, ThrowingFunction<PredicateParser, Predicate<Entity>, PredicateParserException> entityPredicateCreator) {
        ENTITY_PREDICATE_CREATORS.put(name.toUpperCase(Locale.US), entityPredicateCreator);
    }

    public static ThrowingFunction<PredicateParser, Predicate<Entity>, PredicateParserException> getEntityPredicateCreator(String name) {
        return ENTITY_PREDICATE_CREATORS.get(name.toUpperCase(Locale.US));
    }

    public static void addStringPredicateCreator(String name, ThrowingFunction<PredicateParser, Predicate<String>, PredicateParserException> stringPredicateCreator) {
        STRING_PREDICATE_CREATORS.put(name.toUpperCase(Locale.US), stringPredicateCreator);
    }

    public static ThrowingFunction<PredicateParser, Predicate<String>, PredicateParserException> getStringPredicateCreator(String name) {
        return STRING_PREDICATE_CREATORS.get(name.toUpperCase(Locale.US));
    }

    @Nullable
    public static IPointMachineBehavior getPointMachineBehavior(Block block) {
        return POINT_MACHINE_BEHAVIORS.get(block);
    }

    public static void addPointMachineBehavior(Block block, IPointMachineBehavior pointMachineBehavior) {
        POINT_MACHINE_BEHAVIORS.put(block, pointMachineBehavior);
    }

    public static Map<Block, IPointMachineBehavior> getPointMachineBehaviors() {
        return POINT_MACHINE_BEHAVIORS;
    }

    @Nullable
    public static Module<?> getModuleFromItem(Item item) {
        return ITEM_TO_MODULE.get(item);
    }

    public static void generateItemToModuleMap() {
        for (ModuleType type : ((IForgeRegistry)MODULE_TYPE.get()).getValues()) {
            Collection<Module<?>> modules = type.getValues();
            for (Module<?> module : modules) {
                if (!module.isActive()) continue;
                Item item = module.func_199767_j();
                Module<?> originalModule = ITEM_TO_MODULE.get(item);
                if (originalModule == null) {
                    ITEM_TO_MODULE.put(module.func_199767_j(), module);
                    continue;
                }
                LOGGER.warn("Found multiple modules using same item: {}, new module: {}, old module: {}", (Object)item.getRegistryName(), (Object)module.getRegistryName(), (Object)originalModule.getRegistryName());
            }
        }
    }

    public static void setNetworkHandler(INetworkHandler newNetworkHandler) {
        if (networkHandler != null) {
            throw new IllegalStateException("Tried to start Network Handler again");
        }
        networkHandler = newNetworkHandler;
    }

    public static INetworkHandler getNetworkHandler() {
        return Objects.requireNonNull(networkHandler, "Network Handler has not been set");
    }

    @Nonnull
    public static IConnectionChecker getConnectionChecker() {
        if (connectionChecker == null) {
            connectionChecker = new NoConnectionChecker();
        }
        return connectionChecker;
    }

    public static void setConnectionChecker(@Nonnull IConnectionChecker connectionChecker) {
        if (TransportAPI.connectionChecker == null) {
            TransportAPI.connectionChecker = connectionChecker;
        } else if (TransportAPI.connectionChecker instanceof ListConnectionChecker) {
            ((ListConnectionChecker)TransportAPI.connectionChecker).getConnectionCheckers().add(connectionChecker);
        } else {
            ListConnectionChecker listConnectionChecker = new ListConnectionChecker();
            listConnectionChecker.getConnectionCheckers().add(TransportAPI.connectionChecker);
            listConnectionChecker.getConnectionCheckers().add(connectionChecker);
            TransportAPI.connectionChecker = listConnectionChecker;
        }
    }

    public static ModuleSlot getModuleSlot(String moduleSlot) {
        return TransportAPI.getModuleSlot(new ResourceLocation(moduleSlot));
    }

    public static ModuleSlot getModuleSlot(ResourceLocation resourceLocation) {
        return (ModuleSlot)((IForgeRegistry)MODULE_SLOT.get()).getValue(resourceLocation);
    }

    static {
        connectionChecker = null;
        POINT_MACHINE_BEHAVIORS = Maps.newHashMap();
        ENTITY_PREDICATE_CREATORS = Maps.newHashMap();
        STRING_PREDICATE_CREATORS = Maps.newHashMap();
        ITEM_TO_MODULE = Maps.newHashMap();
        CARGO = Lazy.of(() -> (ForgeRegistry)RegistryManager.ACTIVE.getRegistry(CargoModule.class));
        ENGINES = Lazy.of(() -> RegistryManager.ACTIVE.getRegistry(EngineModule.class));
        MODULE_TYPE = Lazy.of(() -> RegistryManager.ACTIVE.getRegistry(ModuleType.class));
        MODULE_SLOT = Lazy.of(() -> RegistryManager.ACTIVE.getRegistry(ModuleSlot.class));
        HULL_TYPE = Lazy.of(() -> RegistryManager.ACTIVE.getRegistry(HullType.class));
    }
}

