/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjanitor.command;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.mods.ftbjanitor.JERDimData;
import dev.ftb.mods.ftbjanitor.JERScanner;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.loading.FMLPaths;

public class JERCommands {
    public static void register(LiteralArgumentBuilder<CommandSource> command) {
        command.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"jer_worldgen").then(Commands.func_197057_a((String)"start").executes(context -> JERCommands.jerStart((CommandSource)context.getSource())))).then(Commands.func_197057_a((String)"stop").executes(context -> JERCommands.jerStop((CommandSource)context.getSource()))));
    }

    private static int jerStart(CommandSource source) {
        if (JERScanner.current != null) {
            source.func_197030_a((ITextComponent)new StringTextComponent("JER Scanner is already running!"), false);
            return 0;
        }
        Path config = FMLPaths.CONFIGDIR.get().resolve("jer-world-gen-config.json");
        if (!Files.exists(config, new LinkOption[0])) {
            try {
                JsonObject json = new JsonObject();
                JsonArray blocks = new JsonArray();
                blocks.add("#forge:ores");
                json.add("block_whitelist", (JsonElement)blocks);
                JsonObject dimensions = new JsonObject();
                for (ServerWorld world : source.func_197028_i().func_212370_w()) {
                    dimensions.addProperty(world.func_234923_W_().func_240901_a_().toString(), Boolean.valueOf(true));
                }
                json.add("dimensions", (JsonElement)dimensions);
                json.addProperty("height", (Number)128);
                json.addProperty("scan_radius", (Number)25);
                Files.write(config, Collections.singleton(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json)), new OpenOption[0]);
                source.func_197030_a((ITextComponent)new StringTextComponent("config/jer-world-gen-config.json created! After you've configured it, run this command again!"), false);
                return 0;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            int n;
            block19: {
                BufferedReader reader = Files.newBufferedReader(config);
                try {
                    JsonObject json = (JsonObject)new GsonBuilder().setLenient().create().fromJson((Reader)reader, JsonObject.class);
                    int height = MathHelper.func_76125_a((int)json.get("height").getAsInt(), (int)16, (int)256);
                    int radius = MathHelper.func_76125_a((int)json.get("scan_radius").getAsInt(), (int)1, (int)200);
                    int startX = MathHelper.func_76128_c((double)source.func_197036_d().field_72450_a) >> 4;
                    int startZ = MathHelper.func_76128_c((double)source.func_197036_d().field_72449_c) >> 4;
                    HashSet<Block> blocks = new HashSet<Block>();
                    for (Object e : json.get("block_whitelist").getAsJsonArray()) {
                        String s = e.getAsString();
                        if (s.startsWith("#")) {
                            ITag tag = TagCollectionManager.func_242178_a().func_241835_a().func_199910_a(new ResourceLocation(s.substring(1)));
                            if (tag == null) continue;
                            blocks.addAll(tag.func_230236_b_());
                            continue;
                        }
                        blocks.add((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(s)));
                    }
                    blocks.remove(Blocks.field_150350_a);
                    JERScanner.current = new JERScanner(height, radius, startX, startZ, blocks);
                    JsonObject dimensions = json.get("dimensions").getAsJsonObject();
                    for (ServerWorld world : source.func_197028_i().func_212370_w()) {
                        String id = world.func_234923_W_().func_240901_a_().toString();
                        if (!dimensions.has(id) || !dimensions.get(id).getAsBoolean()) continue;
                        JERScanner.current.dimensions.add(new JERDimData(JERScanner.current, world));
                    }
                    JERScanner.current.stop = false;
                    if (source.func_197022_f() instanceof PlayerEntity) {
                        PlayerEntity p = (PlayerEntity)source.func_197022_f();
                        JERScanner.current.callback = text -> p.func_146105_b(text, true);
                    } else {
                        JERScanner.current.callback = text -> source.func_197030_a(text, false);
                    }
                    Util.func_240992_g_().execute(JERScanner.current);
                    source.func_197030_a((ITextComponent)new StringTextComponent("JER Scanner started!"), false);
                    n = 1;
                    if (reader == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ((Reader)reader).close();
            }
            return n;
        }
        return 0;
    }

    private static int jerStop(CommandSource source) {
        if (JERScanner.current != null) {
            JERScanner.current.stop();
            JERScanner.current = null;
            source.func_197030_a((ITextComponent)new StringTextComponent("JER Scanner stopped!"), false);
            return 1;
        }
        source.func_197021_a((ITextComponent)new StringTextComponent("JER Scanner isn't running!"));
        return 0;
    }
}

