/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbjanitor;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.mods.ftbjanitor.FTBJanitor;
import dev.ftb.mods.ftbjanitor.FTBJanitorCommon;
import dev.ftb.mods.ftbjanitor.command.FTBJanitorCommands;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="ftbjanitor", value={Dist.CLIENT})
public class FTBJanitorClient
extends FTBJanitorCommon {
    @Override
    public void registerCommands(LiteralArgumentBuilder<CommandSource> command, LiteralArgumentBuilder<CommandSource> dump) {
        dump.then(Commands.func_197057_a((String)"client_resources").executes(context -> this.dumpClientResources((CommandSource)context.getSource())));
    }

    private int dumpClientResources(CommandSource source) {
        Minecraft.func_71410_x().execute(() -> {
            ArrayList<Pair> list = new ArrayList<Pair>();
            long totalSize = 0L;
            byte[] buffer = new byte[Short.MAX_VALUE];
            source.func_197030_a((ITextComponent)new StringTextComponent("Loading client resources..."), false);
            IResourceManager manager = Minecraft.func_71410_x().func_195551_G();
            LinkedHashSet locations = new LinkedHashSet();
            StringUtils.ignoreResourceLocationErrors = true;
            try {
                locations.addAll(manager.func_199003_a(".", StringUtils.ALWAYS_TRUE));
                locations.addAll(manager.func_199003_a("textures", StringUtils.ALWAYS_TRUE));
                locations.addAll(manager.func_199003_a("font", StringUtils.ALWAYS_TRUE));
                locations.addAll(manager.func_199003_a("lang", StringUtils.ALWAYS_TRUE));
                locations.addAll(manager.func_199003_a("blockstates", StringUtils.ALWAYS_TRUE));
                locations.addAll(manager.func_199003_a("models", StringUtils.ALWAYS_TRUE));
                locations.addAll(manager.func_199003_a("particles", StringUtils.ALWAYS_TRUE));
                locations.addAll(manager.func_199003_a("shaders", StringUtils.ALWAYS_TRUE));
                locations.addAll(manager.func_199003_a("texts", StringUtils.ALWAYS_TRUE));
                locations.addAll(manager.func_199003_a("sounds", StringUtils.ALWAYS_TRUE));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            StringUtils.ignoreResourceLocationErrors = false;
            for (ResourceLocation res : locations) {
                long size = 0L;
                try (InputStream stream = manager.func_199002_a(res).func_199027_b();){
                    int i;
                    do {
                        i = stream.read(buffer);
                        size += (long)i;
                    } while (i > 0);
                }
                catch (Exception ex) {
                    size = 0L;
                }
                list.add(Pair.of((Object)res, (Object)size));
                totalSize += size;
                FTBJanitor.LOGGER.info("Found " + res + ": " + size);
            }
            ArrayList<String> lines = new ArrayList<String>();
            list.stream().sorted((o1, o2) -> Long.compare((Long)o2.getValue(), (Long)o1.getValue())).forEach(p -> lines.add(p.getKey() + ": " + p.getValue()));
            lines.add("");
            lines.add("Resource count: " + list.size() + ", total size: " + totalSize + " bytes");
            lines.add("Resource packs: " + manager.func_230232_b_().map(IResourcePack::func_195762_a).sorted().collect(Collectors.joining(", ")));
            try {
                String filename = "client-resource-dump-" + Instant.now().toString().replaceAll("[:T]", "-") + ".txt";
                Files.write(source.func_197028_i().func_240776_a_(FolderName.field_237253_i_).resolve(filename), lines, new OpenOption[0]);
                source.func_197030_a((ITextComponent)new StringTextComponent("Client resource dump saved as " + filename), true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            source.func_197030_a((ITextComponent)new StringTextComponent("Resource count: " + list.size() + ", total size: " + totalSize + " bytes"), false);
        });
        return 1;
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (FTBJanitorCommands.autofly && event.phase == TickEvent.Phase.START) {
            Minecraft.func_71410_x().field_71474_y.field_74351_w.func_225593_a_(true);
        }
    }
}

