/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.forge.impl.builders;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigListEntry;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class FieldBuilder<T, A extends AbstractConfigListEntry> {
    private final @NotNull ITextComponent fieldNameKey;
    private final @NotNull ITextComponent resetButtonKey;
    protected boolean requireRestart = false;
    protected @Nullable Supplier<T> defaultValue = null;
    protected @Nullable Function<T, Optional<ITextComponent>> errorSupplier;

    protected FieldBuilder(ITextComponent resetButtonKey, ITextComponent fieldNameKey) {
        this.resetButtonKey = Objects.requireNonNull(resetButtonKey);
        this.fieldNameKey = Objects.requireNonNull(fieldNameKey);
    }

    public final @Nullable Supplier<T> getDefaultValue() {
        return this.defaultValue;
    }

    @Deprecated
    public final AbstractConfigListEntry buildEntry() {
        return this.build();
    }

    public abstract @NotNull A build();

    public final @NotNull ITextComponent getFieldNameKey() {
        return this.fieldNameKey;
    }

    public final @NotNull ITextComponent getResetButtonKey() {
        return this.resetButtonKey;
    }

    public boolean isRequireRestart() {
        return this.requireRestart;
    }

    public void requireRestart(boolean requireRestart) {
        this.requireRestart = requireRestart;
    }
}

