/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.autoconfig.gui;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.MultiElementListEntry;
import me.shedaniel.clothconfig2.gui.entries.NestedListListEntry;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultGuiProviders {
    private static final ConfigEntryBuilder ENTRY_BUILDER = ConfigEntryBuilder.create();
    private static final Function<Enum<?>, ITextComponent> DEFAULT_NAME_PROVIDER = t -> new TranslationTextComponent(t instanceof SelectionListEntry.Translatable ? ((SelectionListEntry.Translatable)((Object)t)).getKey() : t.toString());

    private DefaultGuiProviders() {
    }

    public static GuiRegistry apply(GuiRegistry registry) {
        registry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> Collections.emptyList(), ConfigEntry.Gui.Excluded.class);
        registry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> {
            ConfigEntry.BoundedDiscrete bounds = field.getAnnotation(ConfigEntry.BoundedDiscrete.class);
            return Collections.singletonList(ENTRY_BUILDER.startIntSlider((ITextComponent)new TranslationTextComponent(i13n), Utils.getUnsafely(field, config, 0), (int)bounds.min(), (int)bounds.max()).setDefaultValue(() -> (Integer)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build());
        }, field -> field.getType() == Integer.TYPE || field.getType() == Integer.class, ConfigEntry.BoundedDiscrete.class);
        registry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> {
            ConfigEntry.BoundedDiscrete bounds = field.getAnnotation(ConfigEntry.BoundedDiscrete.class);
            return Collections.singletonList(ENTRY_BUILDER.startLongSlider((ITextComponent)new TranslationTextComponent(i13n), Utils.getUnsafely(field, config, 0L), bounds.min(), bounds.max()).setDefaultValue(() -> (Long)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build());
        }, field -> field.getType() == Long.TYPE || field.getType() == Long.class, ConfigEntry.BoundedDiscrete.class);
        registry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> {
            ConfigEntry.ColorPicker colorPicker = field.getAnnotation(ConfigEntry.ColorPicker.class);
            return Collections.singletonList(ENTRY_BUILDER.startColorField((ITextComponent)new TranslationTextComponent(i13n), Utils.getUnsafely(field, config, 0)).setAlphaMode(colorPicker.allowAlpha()).setDefaultValue(() -> (Integer)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build());
        }, field -> field.getType() == Integer.TYPE || field.getType() == Integer.class, ConfigEntry.ColorPicker.class);
        registry.registerAnnotationProvider(DefaultGuiProviders::getChildren, field -> !field.getType().isPrimitive(), ConfigEntry.Gui.TransitiveObject.class);
        registry.registerAnnotationProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(ENTRY_BUILDER.startSubCategory((ITextComponent)new TranslationTextComponent(i13n), DefaultGuiProviders.getChildren(i13n, field, config, defaults, guiProvider)).setExpanded(field.getAnnotation(ConfigEntry.Gui.CollapsibleObject.class).startExpanded()).build()), field -> !field.getType().isPrimitive(), ConfigEntry.Gui.CollapsibleObject.class);
        registry.registerPredicateProvider((i13n, field, config, defaults, guiProvider) -> {
            ?[] enumConstants = field.getType().getEnumConstants();
            Enum[] enums = new Enum[enumConstants.length];
            for (int i = 0; i < enumConstants.length; ++i) {
                enums[i] = (Enum)enumConstants[i];
            }
            return Collections.singletonList(ENTRY_BUILDER.startSelector((ITextComponent)new TranslationTextComponent(i13n), enums, Utils.getUnsafely(field, config, (Enum)Utils.getUnsafely(field, defaults))).setDefaultValue((Enum)((Object)((Supplier<Enum>)() -> (Enum)Utils.getUnsafely(field, defaults)))).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build());
        }, field -> field.getType().isEnum() && field.isAnnotationPresent(ConfigEntry.Gui.EnumHandler.class) && field.getAnnotation(ConfigEntry.Gui.EnumHandler.class).option() == ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON);
        registry.registerPredicateProvider((i13n, field, config, defaults, guiProvider) -> {
            List<Enum> enums = Arrays.asList((Enum[])field.getType().getEnumConstants());
            return Collections.singletonList(ENTRY_BUILDER.startDropdownMenu((ITextComponent)new TranslationTextComponent(i13n), DropdownMenuBuilder.TopCellElementBuilder.of(Utils.getUnsafely(field, config, (Enum)Utils.getUnsafely(field, defaults)), str -> {
                String s = new StringTextComponent(str).getString();
                for (Enum constant : enums) {
                    if (!DEFAULT_NAME_PROVIDER.apply(constant).getString().equals(s)) continue;
                    return constant;
                }
                return null;
            }, DEFAULT_NAME_PROVIDER), DropdownMenuBuilder.CellCreatorBuilder.of(DEFAULT_NAME_PROVIDER)).setSelections(enums).setDefaultValue((Enum)((Object)((Supplier<Enum>)() -> (Enum)Utils.getUnsafely(field, defaults)))).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build());
        }, field -> field.getType().isEnum());
        registry.registerPredicateProvider((i13n, field, config, defaults, registry1) -> Collections.singletonList(ENTRY_BUILDER.startIntList((ITextComponent)new TranslationTextComponent(i13n), (List)Utils.getUnsafely(field, config)).setDefaultValue(() -> (List)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build()), DefaultGuiProviders.isListOfType(new Type[]{Integer.class}));
        registry.registerPredicateProvider((i13n, field, config, defaults, registry1) -> Collections.singletonList(ENTRY_BUILDER.startLongList((ITextComponent)new TranslationTextComponent(i13n), (List)Utils.getUnsafely(field, config)).setDefaultValue(() -> (List)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build()), DefaultGuiProviders.isListOfType(new Type[]{Long.class}));
        registry.registerPredicateProvider((i13n, field, config, defaults, registry1) -> Collections.singletonList(ENTRY_BUILDER.startFloatList((ITextComponent)new TranslationTextComponent(i13n), (List)Utils.getUnsafely(field, config)).setDefaultValue(() -> (List)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build()), DefaultGuiProviders.isListOfType(new Type[]{Float.class}));
        registry.registerPredicateProvider((i13n, field, config, defaults, registry1) -> Collections.singletonList(ENTRY_BUILDER.startDoubleList((ITextComponent)new TranslationTextComponent(i13n), (List)Utils.getUnsafely(field, config)).setDefaultValue(() -> (List)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build()), DefaultGuiProviders.isListOfType(new Type[]{Double.class}));
        registry.registerPredicateProvider((i13n, field, config, defaults, registry1) -> Collections.singletonList(ENTRY_BUILDER.startStrList((ITextComponent)new TranslationTextComponent(i13n), (List)Utils.getUnsafely(field, config)).setDefaultValue(() -> (List)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build()), DefaultGuiProviders.isListOfType(new Type[]{String.class}));
        registry.registerPredicateProvider((i13n, field, config, defaults, registry1) -> {
            List configValue = (List)Utils.getUnsafely(field, config);
            Class fieldTypeParam = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            Object defaultElemValue = Utils.constructUnsafely(fieldTypeParam);
            String remainingI13n = i13n.substring(0, i13n.indexOf(".option") + ".option".length());
            String classI13n = String.format("%s.%s", remainingI13n, fieldTypeParam.getSimpleName());
            return Collections.singletonList(new NestedListListEntry<Object, MultiElementListEntry>((ITextComponent)new TranslationTextComponent(i13n), configValue, false, null, newValue -> Utils.setUnsafely(field, config, newValue), () -> (List)Utils.getUnsafely(field, defaults), ENTRY_BUILDER.getResetButtonKey(), true, false, (elem, nestedListListEntry) -> {
                if (elem == null) {
                    Object newDefaultElemValue = Utils.constructUnsafely(fieldTypeParam);
                    return new MultiElementListEntry((ITextComponent)new TranslationTextComponent(classI13n), newDefaultElemValue, DefaultGuiProviders.getChildren(classI13n, fieldTypeParam, newDefaultElemValue, defaultElemValue, registry1), true);
                }
                return new MultiElementListEntry<Object>((ITextComponent)new TranslationTextComponent(classI13n), elem, DefaultGuiProviders.getChildren(classI13n, fieldTypeParam, elem, defaultElemValue, registry1), true);
            }));
        }, DefaultGuiProviders.isNotListOfType(new Type[]{Integer.class, Long.class, Float.class, Double.class, String.class}));
        registry.registerTypeProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(ENTRY_BUILDER.startBooleanToggle((ITextComponent)new TranslationTextComponent(i13n), Utils.getUnsafely(field, config, false)).setDefaultValue(() -> (Boolean)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).setYesNoTextSupplier(bool -> {
            String key = i13n + ".boolean." + bool;
            String translate = I18n.func_135052_a((String)key, (Object[])new Object[0]);
            if (translate.equals(key)) {
                return new TranslationTextComponent("text.cloth-config.boolean.value." + bool);
            }
            return new StringTextComponent(translate);
        }).build()), Boolean.TYPE, Boolean.class);
        registry.registerTypeProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(ENTRY_BUILDER.startIntField((ITextComponent)new TranslationTextComponent(i13n), Utils.getUnsafely(field, config, 0)).setDefaultValue(() -> (Integer)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build()), Integer.TYPE, Integer.class);
        registry.registerTypeProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(ENTRY_BUILDER.startIntList((ITextComponent)new TranslationTextComponent(i13n), Lists.newArrayList((Object[])Utils.getUnsafely(field, config, new Integer[0]))).setDefaultValue(() -> (List)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue.toArray(new Integer[0]))).build()), Integer[].class);
        registry.registerTypeProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(ENTRY_BUILDER.startLongField((ITextComponent)new TranslationTextComponent(i13n), Utils.getUnsafely(field, config, 0L)).setDefaultValue(() -> (Long)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build()), Long.TYPE, Long.class);
        registry.registerTypeProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(ENTRY_BUILDER.startFloatField((ITextComponent)new TranslationTextComponent(i13n), Utils.getUnsafely(field, config, Float.valueOf(0.0f)).floatValue()).setDefaultValue(() -> (Float)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build()), Float.TYPE, Float.class);
        registry.registerTypeProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(ENTRY_BUILDER.startDoubleField((ITextComponent)new TranslationTextComponent(i13n), Utils.getUnsafely(field, config, 0.0)).setDefaultValue(() -> (Double)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build()), Double.TYPE, Double.class);
        registry.registerTypeProvider((i13n, field, config, defaults, guiProvider) -> Collections.singletonList(ENTRY_BUILDER.startStrField((ITextComponent)new TranslationTextComponent(i13n), Utils.getUnsafely(field, config, "")).setDefaultValue(() -> (String)Utils.getUnsafely(field, defaults)).setSaveConsumer(newValue -> Utils.setUnsafely(field, config, newValue)).build()), String.class);
        return registry;
    }

    private static List<AbstractConfigListEntry> getChildren(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess guiProvider) {
        return DefaultGuiProviders.getChildren(i13n, field.getType(), Utils.getUnsafely(field, config), Utils.getUnsafely(field, defaults), guiProvider);
    }

    private static List<AbstractConfigListEntry> getChildren(String i13n, Class<?> fieldType, Object iConfig, Object iDefaults, GuiRegistryAccess guiProvider) {
        return Arrays.stream(fieldType.getDeclaredFields()).map(iField -> {
            String iI13n = String.format("%s.%s", i13n, iField.getName());
            return guiProvider.getAndTransform(iI13n, (Field)iField, iConfig, iDefaults, guiProvider);
        }).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Predicate<Field> isListOfType(Type ... types) {
        return field -> {
            if (List.class.isAssignableFrom(field.getType()) && field.getGenericType() instanceof ParameterizedType) {
                Type[] args = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                return args.length == 1 && Stream.of(types).anyMatch(type -> Objects.equals(args[0], type));
            }
            return false;
        };
    }

    private static Predicate<Field> isNotListOfType(Type ... types) {
        return field -> {
            if (List.class.isAssignableFrom(field.getType()) && field.getGenericType() instanceof ParameterizedType) {
                Type[] args = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
                return args.length == 1 && Stream.of(types).noneMatch(type -> Objects.equals(args[0], type));
            }
            return false;
        };
    }
}

