/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.item;

import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.item.IColorableItem;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.item.FluidContainerItemAugmentable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class PotionInfuserItem
extends FluidContainerItemAugmentable
implements IColorableItem,
IDyeableArmorItem,
IMultiModeItem {
    protected static final int TIME_CONSTANT = 32;
    protected static final int MB_PER_CYCLE = 50;
    protected static final int MB_PER_USE = 250;

    public PotionInfuserItem(Item.Properties builder, int fluidCapacity) {
        this(builder, fluidCapacity, FluidHelper::hasPotionTag);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("color"), (stack, world, entity) -> this.func_200883_f_(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("state"), (stack, world, entity) -> (this.getFluidAmount(stack) > 0 ? 0.5f : 0.0f) + (this.getMode(stack) > 0 ? 0.25f : 0.0f));
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalConfig.toolAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "Fluid", "Potion", "Filter"});
    }

    public PotionInfuserItem(Item.Properties builder, int fluidCapacity, Predicate<FluidStack> validator) {
        super(builder, fluidCapacity, validator);
    }

    public PotionInfuserItem setNumSlots(IntSupplier numSlots) {
        this.numSlots = numSlots;
        return this;
    }

    public PotionInfuserItem setAugValidator(BiPredicate<ItemStack, List<ItemStack>> augValidator) {
        this.augValidator = augValidator;
        return this;
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.thermal.infuser.use").func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.thermal.infuser.use.sneak").func_240699_a_(TextFormatting.DARK_GRAY));
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)("info.thermal.infuser.mode." + this.getMode(stack))).func_240699_a_(TextFormatting.ITALIC));
        this.addIncrementModeChangeTooltip(stack, worldIn, tooltip, flagIn);
        FluidStack fluid = this.getFluid(stack);
        ArrayList<EffectInstance> effects = new ArrayList<EffectInstance>();
        for (EffectInstance effect : PotionUtils.func_185185_a((CompoundNBT)fluid.getTag())) {
            effects.add(new EffectInstance(effect.func_188419_a(), this.getEffectDuration(effect, stack), this.getEffectAmplifier(effect, stack), effect.func_82720_e(), effect.func_188418_e()));
        }
        this.potionTooltip(stack, worldIn, tooltip, flagIn, effects);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        if (this.getFluidAmount(stack) <= 0) {
            return super.getRGBDurabilityForDisplay(stack);
        }
        return this.getFluid(stack).getFluid().getAttributes().getColor(this.getFluid(stack));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return this.useDelegate(stack, playerIn, handIn) ? ActionResult.func_226248_a_((Object)stack) : ActionResult.func_226250_c_((Object)stack);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity player, LivingEntity entity, Hand hand) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && fluid.getAmount() >= 250) {
            if (Utils.isServerWorld((World)entity.field_70170_p)) {
                for (EffectInstance effect : PotionUtils.func_185185_a((CompoundNBT)fluid.getTag())) {
                    if (effect.func_188419_a().func_76403_b()) {
                        effect.func_188419_a().func_180793_a((Entity)player, (Entity)player, entity, effect.func_76458_c(), 0.5);
                        continue;
                    }
                    EffectInstance potion = new EffectInstance(effect.func_188419_a(), this.getEffectDuration(effect, stack) / 2, this.getEffectAmplifier(effect, stack), effect.func_82720_e(), effect.func_188418_e());
                    entity.func_195064_c(potion);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    this.drain(stack, 250, IFluidHandler.FluidAction.EXECUTE);
                }
            }
            player.func_184609_a(hand);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!Utils.timeCheck((World)worldIn)) {
            return;
        }
        if (Utils.isClientWorld((World)worldIn)) {
            return;
        }
        if (!(entityIn instanceof LivingEntity) || Utils.isFakePlayer((Entity)entityIn) || this.getMode(stack) <= 0) {
            return;
        }
        LivingEntity living = (LivingEntity)entityIn;
        FluidStack fluid = this.getFluid(stack);
        if (fluid != null && fluid.getAmount() >= 50) {
            boolean used = false;
            for (EffectInstance effect : PotionUtils.func_185185_a((CompoundNBT)fluid.getTag())) {
                EffectInstance active = (EffectInstance)living.func_193076_bZ().get(effect.func_188419_a());
                if (active != null && active.func_76459_b() >= 40) continue;
                if (effect.func_188419_a().func_76403_b()) {
                    effect.func_188419_a().func_180793_a(null, null, (LivingEntity)entityIn, effect.func_76458_c(), 0.5);
                } else {
                    EffectInstance potion = new EffectInstance(effect.func_188419_a(), this.getEffectDuration(effect, stack) / 4, this.getEffectAmplifier(effect, stack), effect.func_82720_e(), false);
                    living.func_195064_c(potion);
                }
                used = true;
            }
            if (entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).field_71075_bZ.field_75098_d) {
                return;
            }
            if (used) {
                this.drain(stack, 50, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundNBT augmentData) {
        CompoundNBT subTag = container.func_179543_a("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"PotionAmp");
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundNBT)subTag, (CompoundNBT)augmentData, (String)"PotionDur");
        super.setAttributesFromAugment(container, augmentData);
    }

    protected boolean useDelegate(ItemStack stack, PlayerEntity player, Hand hand) {
        FluidStack fluid;
        if (Utils.isFakePlayer((Entity)player) || !player.func_226563_dT_()) {
            return false;
        }
        if (Utils.isServerWorld((World)player.field_70170_p) && (fluid = this.getFluid(stack)) != null && (fluid.getAmount() >= 250 || player.field_71075_bZ.field_75098_d)) {
            for (EffectInstance effect : PotionUtils.func_185185_a((CompoundNBT)fluid.getTag())) {
                if (effect.func_188419_a().func_76403_b()) {
                    effect.func_188419_a().func_180793_a(null, null, (LivingEntity)player, this.getEffectAmplifier(effect, stack), 1.0);
                    continue;
                }
                EffectInstance potion = new EffectInstance(effect.func_188419_a(), this.getEffectDuration(effect, stack), this.getEffectAmplifier(effect, stack), effect.func_82720_e(), false);
                player.func_195064_c(potion);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                this.drain(stack, 250, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        player.func_184609_a(hand);
        stack.func_190915_d(5);
        return true;
    }

    public int getColor(ItemStack item, int colorIndex) {
        if (colorIndex == 0) {
            CompoundNBT nbt = item.func_179543_a("display");
            return nbt != null && nbt.func_150297_b("color", 99) ? nbt.func_74762_e("color") : 0xFFFFFF;
        }
        if (colorIndex == 2) {
            return this.getFluidAmount(item) > 0 ? this.getFluid(item).getFluid().getAttributes().getColor(this.getFluid(item)) : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public void onModeChange(PlayerEntity player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.4f, 0.6f + 0.2f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.thermal.infuser.mode." + this.getMode(stack)));
    }
}

