/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.routing;

import com.refinedmods.refinedpipes.routing.Edge;
import com.refinedmods.refinedpipes.routing.Graph;
import com.refinedmods.refinedpipes.routing.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DijkstraAlgorithm<T> {
    private final List<Edge<T>> edges;
    private Set<Node<T>> settledNodes;
    private Set<Node<T>> unSettledNodes;
    private Map<Node<T>, Node<T>> predecessors;
    private Map<Node<T>, Integer> distance;

    public DijkstraAlgorithm(Graph<T> graph) {
        this.edges = new ArrayList<Edge<T>>(graph.getEdges());
    }

    public void execute(Node<T> source) {
        this.settledNodes = new HashSet<Node<T>>();
        this.unSettledNodes = new HashSet<Node<T>>();
        this.distance = new HashMap<Node<T>, Integer>();
        this.predecessors = new HashMap<Node<T>, Node<T>>();
        this.distance.put(source, 0);
        this.unSettledNodes.add(source);
        while (this.unSettledNodes.size() > 0) {
            Node<T> node = this.getMinimum(this.unSettledNodes);
            this.settledNodes.add(node);
            this.unSettledNodes.remove(node);
            this.findMinimalDistances(node);
        }
    }

    private void findMinimalDistances(Node<T> node) {
        List<Node<T>> adjacentNodes = this.getNeighbors(node);
        for (Node<T> target : adjacentNodes) {
            if (this.getShortestDistance(target) <= this.getShortestDistance(node) + this.getDistance(node, target)) continue;
            this.distance.put(target, this.getShortestDistance(node) + this.getDistance(node, target));
            this.predecessors.put(target, node);
            this.unSettledNodes.add(target);
        }
    }

    private int getDistance(Node<T> node, Node<T> target) {
        for (Edge<T> edge : this.edges) {
            if (!edge.getSource().equals(node) || !edge.getDestination().equals(target)) continue;
            return edge.getWeight();
        }
        throw new RuntimeException("Should not happen");
    }

    private List<Node<T>> getNeighbors(Node<T> node) {
        ArrayList<Node<T>> neighbors = new ArrayList<Node<T>>();
        for (Edge<T> edge : this.edges) {
            if (!edge.getSource().equals(node) || this.isSettled(edge.getDestination())) continue;
            neighbors.add(edge.getDestination());
        }
        return neighbors;
    }

    private Node<T> getMinimum(Set<Node<T>> nodes) {
        Node<T> minimum = null;
        for (Node<T> node : nodes) {
            if (minimum == null) {
                minimum = node;
                continue;
            }
            if (this.getShortestDistance(node) >= this.getShortestDistance(minimum)) continue;
            minimum = node;
        }
        return minimum;
    }

    private boolean isSettled(Node<T> node) {
        return this.settledNodes.contains(node);
    }

    private int getShortestDistance(Node<T> destination) {
        Integer d = this.distance.get(destination);
        if (d == null) {
            return Integer.MAX_VALUE;
        }
        return d;
    }

    public LinkedList<Node<T>> getPath(Node<T> target) {
        LinkedList<Node<T>> path = new LinkedList<Node<T>>();
        Node<T> step = target;
        if (this.predecessors.get(step) == null) {
            return null;
        }
        path.add(step);
        while (this.predecessors.get(step) != null) {
            step = this.predecessors.get(step);
            path.add(step);
        }
        Collections.reverse(path);
        return path;
    }
}

